/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.sqlmm;

import java.util.List;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.sqlmm.SQLMM;
import org.apache.sis.filter.sqlmm.SpatialFunction;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;

class OneGeometry<R>
extends SpatialFunction<R> {
    private static final long serialVersionUID = 3895562608419096524L;
    final Expression<R, GeometryWrapper> geometry;

    OneGeometry(SQLMM operation, Expression<R, ?>[] parameters, Geometries<?> library) {
        super(operation, parameters);
        this.geometry = OneGeometry.toGeometryWrapper(library, parameters[0]);
    }

    @Override
    public Expression<R, Object> recreate(Expression<R, ?>[] effective) {
        return new OneGeometry<R>(this.operation, effective, this.getGeometryLibrary());
    }

    @Override
    final Geometries<?> getGeometryLibrary() {
        return OneGeometry.getGeometryLibrary(this.geometry);
    }

    @Override
    public Class<? super R> getResourceClass() {
        return this.geometry.getResourceClass();
    }

    @Override
    public List<Expression<R, ?>> getParameters() {
        return List.of(OneGeometry.unwrap(this.geometry));
    }

    @Override
    public Object apply(R input) {
        GeometryWrapper value = this.geometry.apply(input);
        if (value != null) {
            try {
                return value.operation(this.operation);
            }
            catch (RuntimeException e) {
                this.warning(e, false);
            }
        }
        return null;
    }

    static final class WithArgument<R>
    extends OneGeometry<R> {
        private static final long serialVersionUID = 2422322830405666146L;
        final Expression<R, ?> argument;

        WithArgument(SQLMM operation, Expression<R, ?>[] parameters, Geometries<?> library) {
            super(operation, parameters, library);
            this.argument = parameters[1];
        }

        @Override
        public Expression<R, Object> recreate(Expression<R, ?>[] effective) {
            return new WithArgument<R>(this.operation, effective, this.getGeometryLibrary());
        }

        @Override
        public Class<? super R> getResourceClass() {
            return WithArgument.specializedClass(super.getResourceClass(), this.argument.getResourceClass());
        }

        @Override
        public List<Expression<R, ?>> getParameters() {
            return List.of(WithArgument.unwrap(this.geometry), this.argument);
        }

        @Override
        public Object apply(R input) {
            GeometryWrapper value = (GeometryWrapper)this.geometry.apply(input);
            if (value != null) {
                try {
                    return value.operationWithArgument(this.operation, this.argument.apply(input));
                }
                catch (RuntimeException e) {
                    this.warning(e, false);
                }
            }
            return null;
        }
    }
}

