/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.PropertyMap;

final class IndexMap
extends PropertyMap<Integer> {
    IndexMap(PropertyAccessor accessor, KeyNamePolicy keyPolicy) {
        super(accessor, keyPolicy);
    }

    @Override
    public Integer get(Object key) {
        int i;
        if (key instanceof String && (i = this.accessor.indexOf((String)key, false)) >= 0) {
            return i;
        }
        return null;
    }

    @Override
    final Iterator<Map.Entry<String, Integer>> iterator() {
        return new PropertyMap.Iter(){

            @Override
            public Map.Entry<String, Integer> next() {
                int i;
                String name;
                if ((name = IndexMap.this.accessor.name(i = this.index++, IndexMap.this.keyPolicy)) != null) {
                    return new AbstractMap.SimpleImmutableEntry<String, Integer>(name, i);
                }
                throw new NoSuchElementException();
            }
        };
    }
}

