/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.DomainRange;
import org.apache.sis.metadata.StandardImplementation;
import org.apache.sis.metadata.simple.SimpleIdentifier;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.opengis.annotation.UML;
import org.opengis.metadata.Datatype;
import org.opengis.metadata.ExtendedElementInformation;
import org.opengis.metadata.Obligation;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

final class PropertyInformation<E>
extends SimpleIdentifier
implements ExtendedElementInformation,
CheckedContainer<E> {
    private static final long serialVersionUID = 6279709738674566891L;
    private final Class<?> parent;
    private final Class<E> elementType;
    private final byte minimumOccurs;
    private final byte maximumOccurs;
    private volatile Object domainValue;

    PropertyInformation(Citation standard, String property, Method getter, Class<E> elementType, ValueRange range) {
        super(standard, property, getter.isAnnotationPresent(Deprecated.class));
        Class<?> c;
        this.parent = getter.getDeclaringClass();
        this.elementType = elementType;
        UML uml = getter.getAnnotation(UML.class);
        int minimumOccurs = 0;
        int maximumOccurs = 1;
        if (uml != null) {
            switch (uml.obligation()) {
                case MANDATORY: {
                    minimumOccurs = 1;
                    break;
                }
                case FORBIDDEN: {
                    maximumOccurs = 0;
                    break;
                }
                case CONDITIONAL: {
                    minimumOccurs = -1;
                }
            }
        }
        if (maximumOccurs != 0 && ((c = getter.getReturnType()).isArray() || Collection.class.isAssignableFrom(c))) {
            maximumOccurs = -1;
        }
        this.minimumOccurs = minimumOccurs;
        this.maximumOccurs = maximumOccurs;
        this.domainValue = range;
    }

    @Override
    public String getName() {
        return this.code;
    }

    @Override
    public final String getCodeSpace() {
        String codespace = Types.getStandardName(this.parent);
        if (codespace == null) {
            codespace = this.parent.getSimpleName();
        }
        return codespace;
    }

    @Override
    @Deprecated
    public String getShortName() {
        return null;
    }

    @Override
    @Deprecated
    public Integer getDomainCode() {
        return null;
    }

    @Override
    public final InternationalString getDefinition() {
        return Types.getDescription(this.parent, this.code);
    }

    @Override
    public Obligation getObligation() {
        switch (this.minimumOccurs) {
            case -1: {
                return Obligation.CONDITIONAL;
            }
            case 0: {
                return Obligation.OPTIONAL;
            }
        }
        return Obligation.MANDATORY;
    }

    @Override
    public InternationalString getCondition() {
        return null;
    }

    @Override
    public Datatype getDataType() {
        if (CharSequence.class.isAssignableFrom(this.elementType)) {
            return Datatype.CHARACTER_STRING;
        }
        if (CodeList.class.isAssignableFrom(this.elementType)) {
            return Datatype.CODE_LIST;
        }
        if (Enum.class.isAssignableFrom(this.elementType)) {
            return Datatype.ENUMERATION;
        }
        if (Numbers.isInteger(this.elementType)) {
            return Datatype.INTEGER;
        }
        return Datatype.TYPE_CLASS;
    }

    @Override
    public Class<E> getElementType() {
        return this.elementType;
    }

    @Override
    public Integer getMaximumOccurrence() {
        int n = Byte.toUnsignedInt(this.maximumOccurs);
        return n == 255 ? Integer.MAX_VALUE : n;
    }

    @Override
    public InternationalString getDomainValue() {
        DomainRange<E> domain = this.domainValue;
        if (domain != null && !(domain instanceof DomainRange)) {
            try {
                domain = new DomainRange<E>(this.elementType, (ValueRange)((Object)domain));
            }
            catch (IllegalArgumentException e) {
                Logging.unexpectedException(StandardImplementation.LOGGER, PropertyInformation.class, "getDomainValue", e);
                domain = null;
            }
            this.domainValue = domain;
        }
        return domain;
    }

    @Override
    public Collection<String> getParentEntity() {
        return Collections.singleton(this.getCodeSpace());
    }

    @Override
    public InternationalString getRule() {
        return null;
    }

    public InternationalString getRationale() {
        return null;
    }

    @Deprecated
    public Collection<InternationalString> getRationales() {
        return Collections.emptyList();
    }

    @Override
    public Collection<? extends ResponsibleParty> getSources() {
        return this.authority.getCitedResponsibleParties();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (super.equals(obj)) {
            PropertyInformation that = (PropertyInformation)obj;
            return this.parent == that.parent && this.elementType == that.elementType && this.minimumOccurs == that.minimumOccurs && this.maximumOccurs == that.maximumOccurs;
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.parent.hashCode() + 31 * this.code.hashCode() ^ 0x6A4236EB;
    }

    @Override
    protected void appendStringTo(StringBuilder buffer) {
        buffer.append(" : ").append(Types.getCodeLabel(this.getDataType())).append(", ").append(this.getObligation().name().toLowerCase(Locale.US)).append(", maxOccurs=");
        int n = this.getMaximumOccurrence();
        if (n != Integer.MAX_VALUE) {
            buffer.append(n);
        } else {
            buffer.append('\u221e');
        }
        InternationalString domainValue = this.getDomainValue();
        if (domainValue != null) {
            buffer.append(", domain=").append(domainValue);
        }
    }
}

