/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.metadata.iso.citation.DefaultTelephone;
import org.apache.sis.metadata.iso.legacy.LegacyPropertyAdapter;
import org.opengis.metadata.citation.Telephone;
import org.opengis.util.CodeList;

final class LegacyTelephones
extends LegacyPropertyAdapter<String, Telephone> {
    private final CodeList<?> type;

    LegacyTelephones(Collection<Telephone> telephones, CodeList<?> type) {
        super(telephones);
        this.type = type;
    }

    @Override
    protected Telephone wrap(String value) {
        return new DefaultTelephone(value, this.type);
    }

    @Override
    protected String unwrap(Telephone container) {
        CodeList<?> ct;
        if (container instanceof DefaultTelephone && (ct = ((DefaultTelephone)container).numberType) != null && this.type.name().equals(ct.name())) {
            return ((DefaultTelephone)container).getNumber();
        }
        return null;
    }

    @Override
    protected boolean update(Telephone container, String value) {
        CodeList<?> ct;
        if (container instanceof DefaultTelephone && ((ct = ((DefaultTelephone)container).numberType) == null || this.type.name().equals(ct.name()))) {
            if (ct == null) {
                ((DefaultTelephone)container).numberType = this.type;
            }
            ((DefaultTelephone)container).setNumber(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(String value) {
        Telephone telephone;
        if (value == null || value.isEmpty()) {
            return false;
        }
        Iterator it = this.elements.iterator();
        if (it.hasNext() && (telephone = (Telephone)it.next()) instanceof DefaultTelephone && ((DefaultTelephone)telephone).isEmpty() && this.update(telephone, value)) {
            return true;
        }
        return this.elements.add(this.wrap(value));
    }
}

