/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Objects;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.InvalidMetadataException;
import org.apache.sis.metadata.internal.ReferencingServices;
import org.apache.sis.metadata.iso.extent.AbstractGeographicExtent;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.operation.TransformException;

@XmlType(name="EX_GeographicBoundingBox_Type", propOrder={"westBoundLongitude", "eastBoundLongitude", "southBoundLatitude", "northBoundLatitude"})
@XmlRootElement(name="EX_GeographicBoundingBox")
public class DefaultGeographicBoundingBox
extends AbstractGeographicExtent
implements GeographicBoundingBox {
    private static final long serialVersionUID = -9200149606040429957L;
    private double westBoundLongitude;
    private double eastBoundLongitude;
    private double southBoundLatitude;
    private double northBoundLatitude;

    public DefaultGeographicBoundingBox() {
        this.westBoundLongitude = Double.NaN;
        this.eastBoundLongitude = Double.NaN;
        this.southBoundLatitude = Double.NaN;
        this.northBoundLatitude = Double.NaN;
    }

    public DefaultGeographicBoundingBox(double westBoundLongitude, double eastBoundLongitude, double southBoundLatitude, double northBoundLatitude) throws IllegalArgumentException {
        super(true);
        DefaultGeographicBoundingBox.verifyBounds(southBoundLatitude, northBoundLatitude);
        this.westBoundLongitude = westBoundLongitude;
        this.eastBoundLongitude = eastBoundLongitude;
        this.southBoundLatitude = southBoundLatitude;
        this.northBoundLatitude = northBoundLatitude;
        this.normalize();
    }

    public DefaultGeographicBoundingBox(GeographicBoundingBox object) {
        super(object);
        if (object != null) {
            this.westBoundLongitude = object.getWestBoundLongitude();
            this.eastBoundLongitude = object.getEastBoundLongitude();
            this.southBoundLatitude = object.getSouthBoundLatitude();
            this.northBoundLatitude = object.getNorthBoundLatitude();
            DefaultGeographicBoundingBox.verifyBounds(this.southBoundLatitude, this.northBoundLatitude);
            this.normalize();
        } else {
            this.westBoundLongitude = Double.NaN;
            this.eastBoundLongitude = Double.NaN;
            this.southBoundLatitude = Double.NaN;
            this.northBoundLatitude = Double.NaN;
        }
    }

    public static DefaultGeographicBoundingBox castOrCopy(GeographicBoundingBox object) {
        if (object == null || object instanceof DefaultGeographicBoundingBox) {
            return (DefaultGeographicBoundingBox)object;
        }
        return new DefaultGeographicBoundingBox(object);
    }

    static boolean getInclusion(Boolean value) throws InvalidMetadataException {
        return value == null || value != false;
    }

    private static Angle valueIfDefined(double value, boolean latitude) {
        return Double.isNaN(value) ? null : (latitude ? new Latitude(value) : new Longitude(value));
    }

    @Override
    @ValueRange(minimum=-180.0, maximum=180.0)
    @XmlElement(name="westBoundLongitude", required=true)
    public double getWestBoundLongitude() {
        return this.westBoundLongitude;
    }

    public void setWestBoundLongitude(double newValue) {
        this.checkWritePermission(DefaultGeographicBoundingBox.valueIfDefined(this.westBoundLongitude, false));
        if (newValue != 180.0) {
            newValue = Longitude.normalize(newValue);
        }
        this.westBoundLongitude = newValue;
    }

    @Override
    @ValueRange(minimum=-180.0, maximum=180.0)
    @XmlElement(name="eastBoundLongitude", required=true)
    public double getEastBoundLongitude() {
        return this.eastBoundLongitude;
    }

    public void setEastBoundLongitude(double newValue) {
        this.checkWritePermission(DefaultGeographicBoundingBox.valueIfDefined(this.eastBoundLongitude, false));
        if (newValue != 180.0) {
            newValue = Longitude.normalize(newValue);
        }
        this.eastBoundLongitude = newValue;
    }

    @Override
    @ValueRange(minimum=-90.0, maximum=90.0)
    @XmlElement(name="southBoundLatitude", required=true)
    public double getSouthBoundLatitude() {
        return this.southBoundLatitude;
    }

    public void setSouthBoundLatitude(double newValue) {
        this.checkWritePermission(DefaultGeographicBoundingBox.valueIfDefined(this.southBoundLatitude, true));
        this.southBoundLatitude = Latitude.clamp(newValue);
        if (this.southBoundLatitude > this.northBoundLatitude) {
            this.northBoundLatitude = Double.NaN;
        }
    }

    @Override
    @ValueRange(minimum=-90.0, maximum=90.0)
    @XmlElement(name="northBoundLatitude", required=true)
    public double getNorthBoundLatitude() {
        return this.northBoundLatitude;
    }

    public void setNorthBoundLatitude(double newValue) {
        this.checkWritePermission(DefaultGeographicBoundingBox.valueIfDefined(this.northBoundLatitude, true));
        this.northBoundLatitude = Latitude.clamp(newValue);
        if (this.northBoundLatitude < this.southBoundLatitude) {
            this.southBoundLatitude = Double.NaN;
        }
    }

    private static void verifyBounds(double southBoundLatitude, double northBoundLatitude) throws IllegalArgumentException {
        if (southBoundLatitude > northBoundLatitude) {
            throw new IllegalArgumentException(Errors.format((short)57, new Latitude(southBoundLatitude), new Latitude(northBoundLatitude), Vocabulary.format((short)112)));
        }
    }

    private void normalize() {
        this.southBoundLatitude = Latitude.clamp(this.southBoundLatitude);
        this.northBoundLatitude = Latitude.clamp(this.northBoundLatitude);
        double span = this.eastBoundLongitude - this.westBoundLongitude;
        if (!(span >= 360.0)) {
            this.westBoundLongitude = Longitude.normalize(this.westBoundLongitude);
            this.eastBoundLongitude = Longitude.normalize(this.eastBoundLongitude);
            if (span != 0.0) {
                if (this.eastBoundLongitude == -180.0) {
                    this.eastBoundLongitude = 180.0;
                }
                return;
            }
            if (!MathFunctions.isPositiveZero(this.westBoundLongitude) || !MathFunctions.isNegativeZero(this.eastBoundLongitude)) {
                return;
            }
        }
        this.westBoundLongitude = -180.0;
        this.eastBoundLongitude = 180.0;
    }

    public void setBounds(double westBoundLongitude, double eastBoundLongitude, double southBoundLatitude, double northBoundLatitude) throws IllegalArgumentException {
        this.checkWritePermission(this.isNonEmpty());
        DefaultGeographicBoundingBox.verifyBounds(southBoundLatitude, northBoundLatitude);
        this.westBoundLongitude = westBoundLongitude;
        this.eastBoundLongitude = eastBoundLongitude;
        this.southBoundLatitude = southBoundLatitude;
        this.northBoundLatitude = northBoundLatitude;
        this.normalize();
    }

    public void setBounds(Envelope envelope) throws TransformException {
        ArgumentChecks.ensureNonNull("envelope", envelope);
        this.checkWritePermission(this.isNonEmpty());
        ReferencingServices.getInstance().setBounds(envelope, this, null);
    }

    public void setBounds(GeographicBoundingBox box) {
        ArgumentChecks.ensureNonNull("box", box);
        this.setBounds(box.getWestBoundLongitude(), box.getEastBoundLongitude(), box.getSouthBoundLatitude(), box.getNorthBoundLatitude());
        this.setInclusion(box.getInclusion());
    }

    private int denormalize(double \u03bbmin, double \u03bbmax) {
        boolean isCrossingAntiMeridian;
        if (\u03bbmin > \u03bbmax == (isCrossingAntiMeridian = this.westBoundLongitude > this.eastBoundLongitude)) {
            return isCrossingAntiMeridian ? 3 : 0;
        }
        double left = this.westBoundLongitude - \u03bbmin;
        double right = \u03bbmax - this.eastBoundLongitude;
        if (!isCrossingAntiMeridian) {
            if (left >= 0.0) {
                return 1;
            }
            if (right >= 0.0) {
                return -1;
            }
            return left < right ? -1 : 1;
        }
        if (!(left <= 0.0) && right <= 0.0 || left > right) {
            this.westBoundLongitude -= 360.0;
            return -2;
        }
        this.eastBoundLongitude += 360.0;
        return 2;
    }

    public void add(GeographicBoundingBox box) {
        this.checkWritePermission(this.isNonEmpty());
        ArgumentChecks.ensureNonNull("box", box);
        double \u03bbmin = box.getWestBoundLongitude();
        double \u03bbmax = box.getEastBoundLongitude();
        double \u03c6min = box.getSouthBoundLatitude();
        double \u03c6max = box.getNorthBoundLatitude();
        boolean i1 = DefaultGeographicBoundingBox.getInclusion(this.getInclusion());
        boolean i2 = DefaultGeographicBoundingBox.getInclusion(box.getInclusion());
        int status = this.denormalize(\u03bbmin, \u03bbmax);
        switch (status) {
            case -1: {
                \u03bbmin -= 360.0;
                break;
            }
            case 1: {
                \u03bbmax += 360.0;
            }
        }
        if (i1 == i2) {
            this.westBoundLongitude = Math.min(this.westBoundLongitude, \u03bbmin);
            this.eastBoundLongitude = Math.max(this.eastBoundLongitude, \u03bbmax);
            this.southBoundLatitude = Math.min(this.southBoundLatitude, \u03c6min);
            this.northBoundLatitude = Math.max(this.northBoundLatitude, \u03c6max);
        } else {
            if (\u03c6min <= this.southBoundLatitude && \u03c6max >= this.northBoundLatitude) {
                this.westBoundLongitude = Math.max(this.westBoundLongitude, \u03bbmin);
                this.eastBoundLongitude = Math.min(this.eastBoundLongitude, \u03bbmax);
            }
            if (\u03bbmin <= this.westBoundLongitude && \u03bbmax >= this.eastBoundLongitude) {
                this.southBoundLatitude = Math.max(this.southBoundLatitude, \u03c6min);
                this.northBoundLatitude = Math.min(this.northBoundLatitude, \u03c6max);
            }
        }
        if (status == 3 && this.eastBoundLongitude > this.westBoundLongitude) {
            this.westBoundLongitude = -180.0;
            this.eastBoundLongitude = 180.0;
        }
        this.normalize();
    }

    public void intersect(GeographicBoundingBox box) throws IllegalArgumentException {
        this.checkWritePermission(this.isNonEmpty());
        ArgumentChecks.ensureNonNull("box", box);
        if (DefaultGeographicBoundingBox.getInclusion(this.getInclusion()) != DefaultGeographicBoundingBox.getInclusion(box.getInclusion())) {
            throw new IllegalArgumentException(Errors.format((short)63, "inclusion"));
        }
        double \u03bbmin = box.getWestBoundLongitude();
        double \u03bbmax = box.getEastBoundLongitude();
        double \u03c6min = box.getSouthBoundLatitude();
        double \u03c6max = box.getNorthBoundLatitude();
        int status = this.denormalize(\u03bbmin, \u03bbmax);
        switch (status) {
            case -1: {
                \u03bbmin -= 360.0;
                break;
            }
            case 1: {
                \u03bbmax += 360.0;
            }
        }
        this.westBoundLongitude = Math.max(this.westBoundLongitude, \u03bbmin);
        this.eastBoundLongitude = Math.min(this.eastBoundLongitude, \u03bbmax);
        this.southBoundLatitude = Math.max(this.southBoundLatitude, \u03c6min);
        this.northBoundLatitude = Math.min(this.northBoundLatitude, \u03c6max);
        if (status != 3 && this.westBoundLongitude > this.eastBoundLongitude) {
            this.eastBoundLongitude = Double.NaN;
            this.westBoundLongitude = Double.NaN;
        }
        if (this.southBoundLatitude > this.northBoundLatitude) {
            this.northBoundLatitude = Double.NaN;
            this.southBoundLatitude = Double.NaN;
        }
        this.normalize();
    }

    private Angle isNonEmpty() {
        double value = this.eastBoundLongitude;
        if (!Double.isNaN(value) || !Double.isNaN(value = this.westBoundLongitude)) {
            return new Longitude(value);
        }
        value = this.northBoundLatitude;
        if (!Double.isNaN(value) || !Double.isNaN(value = this.southBoundLatitude)) {
            return new Latitude(value);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return Double.isNaN(this.eastBoundLongitude) && Double.isNaN(this.westBoundLongitude) && Double.isNaN(this.northBoundLatitude) && Double.isNaN(this.southBoundLatitude);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == DefaultGeographicBoundingBox.class) {
            DefaultGeographicBoundingBox that = (DefaultGeographicBoundingBox)object;
            return Objects.equals(this.getInclusion(), that.getInclusion()) && Double.doubleToLongBits(this.southBoundLatitude) == Double.doubleToLongBits(that.southBoundLatitude) && Double.doubleToLongBits(this.northBoundLatitude) == Double.doubleToLongBits(that.northBoundLatitude) && Double.doubleToLongBits(this.eastBoundLongitude) == Double.doubleToLongBits(that.eastBoundLongitude) && Double.doubleToLongBits(this.westBoundLongitude) == Double.doubleToLongBits(that.westBoundLongitude);
        }
        return super.equals(object, mode);
    }
}

