/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.cs.AxisDirection;

final class Codes {
    final int directions;
    final short unit;
    final short epsg;
    private static final Map<Codes, Codes> EPSG = new HashMap<Codes, Codes>(31);

    private Codes(int directions, short unit, short epsg) {
        this.directions = directions;
        this.unit = unit;
        this.epsg = epsg;
    }

    private static int pack(AxisDirection[] directions) {
        int packed = 0;
        int i = directions.length;
        if (i <= 4) {
            while (--i >= 0) {
                int ordinal = directions[i].ordinal();
                if (ordinal <= 0 || ordinal > 127) {
                    return 0;
                }
                packed = packed << 8 | ordinal;
            }
        }
        return packed;
    }

    static short lookup(Unit<?> unit, AxisDirection[] directions) {
        int p;
        Integer uc = Units.getEpsgCode(unit, true);
        if (uc != null && (p = Codes.pack(directions)) != 0) {
            Codes m = new Codes(p, uc.shortValue(), 0);
            if ((m = EPSG.get(m)) != null) {
                return m.epsg;
            }
        }
        return 0;
    }

    public int hashCode() {
        return this.directions + this.unit;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Codes) {
            Codes other = (Codes)obj;
            return this.directions == other.directions && this.unit == other.unit;
        }
        return false;
    }

    static {
        Object[] directions = new AxisDirection[]{AxisDirection.EAST, AxisDirection.NORTH};
        int addVertical = AxisDirection.UP.ordinal() << 16;
        int packed = Codes.pack((AxisDirection[])directions);
        short unit = 9001;
        int i = 0;
        block19: while (true) {
            int epsg;
            short to3D = 0;
            switch (i) {
                case 0: {
                    epsg = 4400;
                    break;
                }
                case 1: {
                    epsg = 1039;
                    unit = 9002;
                    break;
                }
                case 2: {
                    epsg = 4497;
                    unit = 9003;
                    break;
                }
                case 3: {
                    epsg = 4403;
                    unit = 9005;
                    break;
                }
                case 4: {
                    epsg = 6424;
                    to3D = 6426;
                    unit = 9122;
                    break;
                }
                case 5: {
                    epsg = 6425;
                    to3D = 6427;
                    unit = 9105;
                    break;
                }
                case 6: {
                    epsg = 6429;
                    to3D = 6431;
                    unit = 9101;
                    break;
                }
                case 7: {
                    ArraysExt.swap(directions, 0, 1);
                    packed = Codes.pack((AxisDirection[])directions);
                    epsg = 4500;
                    unit = 9001;
                    break;
                }
                case 8: {
                    epsg = 1029;
                    unit = 9002;
                    break;
                }
                case 9: {
                    epsg = 4502;
                    unit = 9005;
                    break;
                }
                case 10: {
                    epsg = 6422;
                    to3D = 6423;
                    unit = 9122;
                    break;
                }
                case 11: {
                    epsg = 6403;
                    to3D = 6421;
                    unit = 9105;
                    break;
                }
                case 12: {
                    epsg = 6428;
                    to3D = 6430;
                    unit = 9101;
                    break;
                }
                case 13: {
                    directions[1] = AxisDirection.WEST;
                    packed = Codes.pack((AxisDirection[])directions);
                    epsg = 4501;
                    unit = 9001;
                    break;
                }
                case 14: {
                    ArraysExt.swap(directions, 0, 1);
                    packed = Codes.pack((AxisDirection[])directions);
                    epsg = 4491;
                    break;
                }
                case 15: {
                    directions[1] = AxisDirection.SOUTH;
                    packed = Codes.pack((AxisDirection[])directions);
                    epsg = 6503;
                    break;
                }
                case 16: {
                    ArraysExt.swap(directions, 0, 1);
                    packed = Codes.pack((AxisDirection[])directions);
                    epsg = 6501;
                    break;
                }
                default: {
                    break block19;
                }
            }
            Codes m = new Codes(packed, unit, (short)epsg);
            if (EPSG.put(m, m) != null) {
                throw new AssertionError(m.epsg);
            }
            if (to3D != 0 && EPSG.put(m = new Codes(packed | addVertical, unit, to3D), m) != null) {
                throw new AssertionError(m.epsg);
            }
            ++i;
        }
    }
}

