/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.aggregate.GridSlice;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.util.InternationalString;

final class GridSliceLocator {
    final int searchDimension;
    private final long[] sliceLows;
    private final long[] sliceHighs;
    private final long[][] offsets;

    GridSliceLocator(List<GridSlice> slices, int searchDimension, GridCoverageResource[] resources) {
        this.searchDimension = searchDimension;
        slices.sort((o1, o2) -> Long.compare(o1.getGridLow(searchDimension), o2.getGridLow(searchDimension)));
        this.sliceLows = new long[resources.length];
        this.sliceHighs = new long[resources.length];
        this.offsets = new long[resources.length][];
        HashMap<GridSlice, long[]> shared = new HashMap<GridSlice, long[]>();
        for (int i = 0; i < resources.length; ++i) {
            GridSlice slice = slices.get(i);
            GridExtent extent = slice.getGridExtent();
            long[] offset = slice.getOffset(shared);
            long dimOff = offset[searchDimension];
            this.sliceLows[i] = Math.subtractExact(extent.getLow(searchDimension), dimOff);
            this.sliceHighs[i] = Math.subtractExact(extent.getHigh(searchDimension), dimOff);
            resources[i] = slice.resource;
            this.offsets[i] = offset;
        }
    }

    final <E> GridGeometry union(GridGeometry base, List<E> slices, Function<E, GridExtent> getter) {
        GridExtent extent = base.getExtent();
        int dimension = extent.getDimension();
        DimensionNameType[] axes = new DimensionNameType[dimension];
        long[] low = new long[dimension];
        long[] high = new long[dimension];
        for (int i = 0; i < dimension; ++i) {
            axes[i] = extent.getAxisType(i).orElse(null);
            low[i] = extent.getLow(i);
            high[i] = extent.getHigh(i);
        }
        boolean changed = false;
        int count = slices.size();
        for (int i = 0; i < count; ++i) {
            GridExtent slice = getter.apply(slices.get(i));
            for (int j = 0; j < dimension; ++j) {
                long offset = this.offsets[i][j];
                long v = Math.subtractExact(slice.getLow(j), offset);
                if (v < low[j]) {
                    low[j] = v;
                    changed = true;
                }
                if ((v = Math.subtractExact(slice.getHigh(j), offset)) <= high[j]) continue;
                high[j] = v;
                changed = true;
            }
        }
        if (!changed) {
            return base;
        }
        extent = new GridExtent(axes, low, high, true);
        return new GridGeometry(extent, GridSlice.CELL_ANCHOR, base.getGridToCRS(GridSlice.CELL_ANCHOR), base.isDefined(1) ? base.getCoordinateReferenceSystem() : null);
    }

    final GridExtent toSliceExtent(GridExtent extent, int slice) {
        return extent.translate(this.offsets[slice]);
    }

    final int getUpper(GridExtent sliceExtent, int fromIndex, int toIndex) {
        long high = sliceExtent.getHigh(this.searchDimension);
        int upper = Arrays.binarySearch(this.sliceLows, fromIndex, toIndex, high);
        if (upper < 0) {
            upper ^= 0xFFFFFFFF;
        } else {
            while (++upper < toIndex && this.sliceLows[upper] <= high) {
            }
        }
        return upper;
    }

    final int getLower(GridExtent sliceExtent, int fromIndex, int toIndex) {
        long low = sliceExtent.getLow(this.searchDimension);
        while (toIndex > fromIndex) {
            if (this.sliceHighs[--toIndex] >= low) continue;
            return toIndex + 1;
        }
        return toIndex;
    }

    final boolean isSlice(GridExtent sliceExtent) {
        return sliceExtent.getLow(this.searchDimension) == sliceExtent.getHigh(this.searchDimension);
    }

    final String getDimensionName(GridExtent extent) {
        return extent.getAxisType(this.searchDimension).map(Types::getCodeTitle).map(InternationalString::toString).orElseGet(() -> String.valueOf(this.searchDimension));
    }
}

