/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.measure.Unit;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.internal.TemporalUtilities;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.DefaultGeocentricCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.factory.GeodeticObjectFactory;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.util.EllipsoidalHeightCombiner;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.netcdf.base.Axis;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Grid;
import org.apache.sis.storage.netcdf.base.GridCacheValue;
import org.apache.sis.storage.netcdf.base.Linearizer;
import org.apache.sis.storage.netcdf.base.NamedElement;
import org.apache.sis.storage.netcdf.base.Variable;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

abstract class CRSBuilder<D extends Datum, CS extends CoordinateSystem> {
    private static final int MAXDIM = 1000;
    private final Class<D> datumType;
    private final String datumBase;
    private final int datumIndex;
    private final int minDim;
    private final int maxDim;
    private int dimension;
    private Axis[] axes;
    protected D datum;
    protected CS coordinateSystem;
    protected SingleCRS referenceSystem;
    private FactoryException warnings;
    static final int DATUM_CACHE_SIZE = 4;

    private CRSBuilder(Class<D> datumType, String datumBase, int datumIndex, int minDim, int maxDim) {
        this.datumType = datumType;
        this.datumBase = datumBase;
        this.datumIndex = datumIndex;
        this.minDim = minDim;
        this.maxDim = maxDim;
        this.axes = new Axis[3];
    }

    public static CoordinateReferenceSystem assemble(Decoder decoder, Grid grid, List<GridCacheValue> linearizations, Matrix reorderGridToCRS) throws DataStoreException, FactoryException, IOException {
        ArrayList builders = new ArrayList(4);
        for (Axis axis : grid.getAxes(decoder)) {
            CRSBuilder.dispatch(builders, axis);
        }
        CoordinateReferenceSystem[] components = new SingleCRS[builders.size()];
        for (int i = 0; i < components.length; ++i) {
            components[i] = ((CRSBuilder)builders.get(i)).build(decoder, true);
        }
        if (linearizations != null && !linearizations.isEmpty()) {
            Linearizer.replaceInCompoundCRS((SingleCRS[])components, linearizations, reorderGridToCRS);
        }
        switch (components.length) {
            case 0: {
                return null;
            }
            case 1: {
                return components[0];
            }
        }
        return new EllipsoidalHeightCombiner(decoder).createCompoundCRS(CRSBuilder.properties(grid.getName()), components);
    }

    static CoordinateReferenceSystem assemble(Decoder decoder, Iterable<Variable> axes, SingleCRS[] time) throws DataStoreException, FactoryException, IOException {
        ArrayList builders = new ArrayList(4);
        for (Variable axis : axes) {
            CRSBuilder.dispatch(builders, new Axis(axis));
        }
        SingleCRS[] components = new SingleCRS[builders.size()];
        int n = 0;
        for (CRSBuilder cRSBuilder : builders) {
            SingleCRS c = cRSBuilder.build(decoder, false);
            if (cRSBuilder instanceof Temporal) {
                time[0] = c;
                continue;
            }
            components[n++] = c;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return components[0];
            }
        }
        return new EllipsoidalHeightCombiner(decoder).createCompoundCRS(ArraysExt.resize(components, n));
    }

    private static void dispatch(List<CRSBuilder<?, ?>> components, Axis axis) throws DataStoreContentException {
        Supplier<CRSBuilder> constructor;
        Class addTo;
        int i;
        int alternative = -1;
        switch (axis.abbreviation) {
            case 'h': {
                i = components.size();
                while (--i >= 0) {
                    if (!(components.get(i) instanceof Projected)) continue;
                    alternative = i;
                    break;
                }
            }
            case '\u03bb': 
            case '\u03c6': {
                addTo = Geographic.class;
                constructor = Geographic::new;
                break;
            }
            case 'r': 
            case '\u03a9': 
            case '\u03b8': {
                addTo = Spherical.class;
                constructor = Spherical::new;
                break;
            }
            case 'E': 
            case 'N': {
                addTo = Projected.class;
                constructor = Projected::new;
                break;
            }
            case 'D': 
            case 'H': {
                addTo = Vertical.class;
                constructor = Vertical::new;
                break;
            }
            case 't': {
                addTo = Temporal.class;
                constructor = Temporal::new;
                break;
            }
            default: {
                addTo = Engineering.class;
                constructor = Engineering::new;
            }
        }
        i = components.size();
        while (--i >= 0) {
            CRSBuilder<?, ?> builder = components.get(i);
            if (!addTo.isInstance(builder) && i != alternative) continue;
            builder.add(axis);
            return;
        }
        CRSBuilder builder = constructor.get();
        if (addTo == Projected.class) {
            int i2 = components.size();
            block10: while (--i2 >= 0) {
                CRSBuilder<?, ?> replace = components.get(i2);
                for (Axis a : replace.axes) {
                    if (a.abbreviation != 'h') continue block10;
                }
                for (Axis a : replace.axes) {
                    builder.add(a);
                }
                components.remove(i2);
                break;
            }
        }
        builder.add(axis);
        components.add(builder);
    }

    private void add(Axis axis) throws DataStoreContentException {
        if (this.dimension > 1000) {
            throw new DataStoreContentException(this.getFirstAxis().coordinates.errors().getString((short)36, "axes", this.dimension));
        }
        if (this.dimension >= this.axes.length) {
            this.axes = Arrays.copyOf(this.axes, this.dimension * 2);
        }
        this.axes[this.dimension++] = axis;
    }

    final boolean is3D() {
        return this.dimension >= 3;
    }

    final Axis getFirstAxis() {
        return this.axes[0];
    }

    private SingleCRS build(Decoder decoder, boolean grid) throws FactoryException, DataStoreException, IOException {
        if (this.dimension > this.maxDim) {
            Variable axis = this.getFirstAxis().coordinates;
            throw new FactoryException(axis.resources().getString((short)10, axis.getFilename(), this.getClass().getSimpleName(), this.dimension, NamedElement.listNames(this.axes, this.dimension, ", ")));
        }
        this.datum = (Datum)this.datumType.cast(decoder.datumCache[this.datumIndex]);
        this.setPredefinedComponents(decoder);
        if (this.datum == null) {
            this.createDatum(decoder.getDatumFactory(), CRSBuilder.properties("Unknown datum presumably based upon ".concat(this.datumBase)));
        }
        decoder.datumCache[this.datumIndex] = this.datum;
        if (this.dimension < this.minDim) {
            Engineering eng = new Engineering();
            System.arraycopy(this.axes, 0, eng.axes, 0, this.dimension);
            eng.dimension = this.dimension;
            eng.datum = decoder.getDatumFactory().createEngineeringDatum(IdentifiedObjects.getProperties(this.datum, new String[]{"identifiers"}));
            eng.createFromDatum(decoder, grid);
            return eng.referenceSystem;
        }
        if (this.coordinateSystem != null) {
            int i = this.dimension;
            while (--i >= 0) {
                Axis expected = this.axes[i];
                if (expected != null && expected.isSameUnitAndDirection(this.coordinateSystem.getAxis(i))) continue;
                this.coordinateSystem = null;
                this.referenceSystem = null;
                break;
            }
        }
        if (this.referenceSystem == null) {
            this.createFromDatum(decoder, grid);
        }
        if (grid) {
            CoordinateSystem cs = this.referenceSystem.getCoordinateSystem();
            int i = cs.getDimension();
            while (--i >= 0) {
                NumberRange<?> range;
                CoordinateSystemAxis axis = cs.getAxis(i);
                if (!RangeMeaning.WRAPAROUND.equals(axis.getRangeMeaning()) || (range = this.axes[i].read().range()) == null || !(range.getMinDouble() >= 0.0) || !(range.getMaxDouble() > axis.getMaximumValue())) continue;
                this.referenceSystem = (SingleCRS)((Object)AbstractCRS.castOrCopy(this.referenceSystem).forConvention(AxesConvention.POSITIVE_RANGE));
                this.coordinateSystem = null;
                break;
            }
        }
        if (this.warnings != null) {
            decoder.listeners.warning(Level.FINE, null, this.warnings);
        }
        return this.referenceSystem;
    }

    private void createFromDatum(Decoder decoder, boolean grid) throws FactoryException, DataStoreException, IOException {
        Map<String, ?> properties;
        if (this.coordinateSystem == null) {
            StringJoiner joiner = new StringJoiner(" ");
            CSFactory csFactory = decoder.getCSFactory();
            CoordinateSystemAxis[] iso = new CoordinateSystemAxis[this.dimension];
            for (int i = 0; i < iso.length; ++i) {
                Axis axis = this.axes[i];
                joiner.add(axis.getName());
                iso[i] = axis.toISO(csFactory, i, grid);
            }
            this.createCS(csFactory, CRSBuilder.properties(joiner.toString()), iso);
            properties = CRSBuilder.properties(this.coordinateSystem.getName());
        } else {
            properties = CRSBuilder.properties(NamedElement.listNames(this.axes, this.dimension, " "));
        }
        this.createCRS(decoder.getCRSFactory(), properties);
    }

    final void recoverableException(FactoryException e) {
        if (this.warnings == null) {
            this.warnings = e;
        } else {
            this.warnings.addSuppressed(e);
        }
    }

    private static Map<String, ?> properties(Object name) {
        return Map.of("name", name);
    }

    final Integer epsgCandidateCS(Unit<?> defaultUnit) {
        Unit<?> unit = this.getFirstAxis().getUnit();
        if (unit == null) {
            unit = defaultUnit;
        }
        AxisDirection[] directions = new AxisDirection[this.dimension];
        for (int i = 0; i < directions.length; ++i) {
            directions[i] = this.axes[i].direction;
        }
        return CoordinateSystems.getEpsgCode(unit, directions);
    }

    abstract void setPredefinedComponents(Decoder var1) throws FactoryException;

    abstract void createDatum(DatumFactory var1, Map<String, ?> var2) throws FactoryException;

    abstract void createCS(CSFactory var1, Map<String, ?> var2, CoordinateSystemAxis[] var3) throws FactoryException;

    abstract void createCRS(CRSFactory var1, Map<String, ?> var2) throws FactoryException;

    private static final class Engineering
    extends CRSBuilder<EngineeringDatum, CoordinateSystem> {
        static final int CACHE_INDEX = 3;

        public Engineering() {
            super(EngineeringDatum.class, "affine coordinate system", 3, 1, 3);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) {
        }

        @Override
        void createDatum(DatumFactory factory, Map<String, ?> properties) throws FactoryException {
            this.datum = factory.createEngineeringDatum(properties);
        }

        @Override
        void createCS(CSFactory factory, Map<String, ?> properties, CoordinateSystemAxis[] axes) throws FactoryException {
            try {
                switch (axes.length) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.coordinateSystem = new DefaultParametricCS(properties, axes[0]);
                        return;
                    }
                    case 2: {
                        this.coordinateSystem = factory.createAffineCS(properties, axes[0], axes[1]);
                        return;
                    }
                    default: {
                        this.coordinateSystem = factory.createAffineCS(properties, axes[0], axes[1], axes[2]);
                        return;
                    }
                }
            }
            catch (InvalidGeodeticParameterException e) {
                this.recoverableException(e);
            }
            this.coordinateSystem = new AbstractCS(properties, axes);
        }

        @Override
        void createCRS(CRSFactory factory, Map<String, ?> properties) throws FactoryException {
            this.referenceSystem = factory.createEngineeringCRS(properties, (EngineeringDatum)this.datum, this.coordinateSystem);
        }
    }

    private static final class Temporal
    extends CRSBuilder<TemporalDatum, TimeCS> {
        static final int CACHE_INDEX = 2;

        public Temporal() {
            super(TemporalDatum.class, "", 2, 1, 1);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) {
            CommonCRS.Temporal predefined;
            Axis axis = this.getFirstAxis();
            Unit<?> unit = axis.getUnit();
            if (Units.DAY.equals(unit)) {
                predefined = CommonCRS.Temporal.JULIAN;
            } else if (Units.SECOND.equals(unit)) {
                predefined = CommonCRS.Temporal.UNIX;
            } else if (Units.MILLISECOND.equals(unit)) {
                predefined = CommonCRS.Temporal.JAVA;
            } else {
                return;
            }
            this.coordinateSystem = predefined.crs().getCoordinateSystem();
        }

        @Override
        void createDatum(DatumFactory factory, Map<String, ?> properties) throws FactoryException {
            Axis axis = this.getFirstAxis();
            axis.getUnit();
            Instant epoch = axis.coordinates.epoch;
            if (epoch != null) {
                CommonCRS.Temporal c = CommonCRS.Temporal.forEpoch(epoch);
                if (c != null) {
                    this.datum = c.datum();
                } else {
                    properties = CRSBuilder.properties("Time since " + epoch);
                    this.datum = factory.createTemporalDatum(properties, TemporalUtilities.toDate(epoch));
                }
            }
        }

        @Override
        void createCS(CSFactory factory, Map<String, ?> properties, CoordinateSystemAxis[] axes) throws FactoryException {
            this.coordinateSystem = factory.createTimeCS(properties, axes[0]);
        }

        @Override
        void createCRS(CRSFactory factory, Map<String, ?> properties) throws FactoryException {
            properties = CRSBuilder.properties(this.getFirstAxis().coordinates.getUnitsString());
            this.referenceSystem = this.datum != null ? factory.createTemporalCRS(properties, (TemporalDatum)this.datum, (TimeCS)this.coordinateSystem) : factory.createEngineeringCRS(properties, CommonCRS.Engineering.TIME.datum(), this.coordinateSystem);
        }
    }

    private static final class Projected
    extends Geodetic<CartesianCS> {
        private CommonCRS sphericalDatum;
        private static final Conversion UNKNOWN_PROJECTION;

        public Projected() {
            super(2);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) throws FactoryException {
            super.setPredefinedComponents(decoder);
            this.sphericalDatum = decoder.convention().defaultHorizontalCRS(true);
            this.datum = this.sphericalDatum.datum();
            if (this.isPredefinedCS(Units.METRE)) {
                this.coordinateSystem = decoder.getStandardProjectedCS();
            }
        }

        @Override
        void createCS(CSFactory factory, Map<String, ?> properties, CoordinateSystemAxis[] axes) throws FactoryException {
            this.coordinateSystem = axes.length > 2 ? factory.createCartesianCS(properties, axes[0], axes[1], axes[2]) : factory.createCartesianCS(properties, axes[0], axes[1]);
        }

        @Override
        void createCRS(CRSFactory factory, Map<String, ?> properties) throws FactoryException {
            GeographicCRS baseCRS;
            boolean is3D = ((CartesianCS)this.coordinateSystem).getDimension() >= 3;
            GeographicCRS geographicCRS = baseCRS = is3D ? this.sphericalDatum.geographic3D() : this.sphericalDatum.geographic();
            if (!baseCRS.getDatum().equals(this.datum)) {
                baseCRS = factory.createGeographicCRS(properties, (GeodeticDatum)this.datum, baseCRS.getCoordinateSystem());
            }
            this.referenceSystem = factory.createProjectedCRS(properties, baseCRS, UNKNOWN_PROJECTION, (CartesianCS)this.coordinateSystem);
        }

        static {
            DefaultCoordinateOperationFactory factory = DefaultCoordinateOperationFactory.provider();
            try {
                OperationMethod method = factory.getOperationMethod("Equidistant Cylindrical (Spherical)");
                UNKNOWN_PROJECTION = factory.createDefiningConversion(CRSBuilder.properties("Not specified (presumed Plate Carr\u00e9e)"), method, method.getParameters().createValue());
            }
            catch (FactoryException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static final class Geographic
    extends Geodetic<EllipsoidalCS> {
        public Geographic() {
            super(2);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) throws FactoryException {
            super.setPredefinedComponents(decoder);
            if (this.isPredefinedCS(Units.DEGREE)) {
                GeographicCRS crs;
                if (this.is3D()) {
                    crs = this.defaultCRS.geographic3D();
                    if (this.isLongitudeFirst) {
                        crs = DefaultGeographicCRS.castOrCopy(crs).forConvention(AxesConvention.RIGHT_HANDED);
                    }
                } else {
                    crs = this.isLongitudeFirst ? this.defaultCRS.normalizedGeographic() : this.defaultCRS.geographic();
                }
                this.referenceSystem = crs;
                this.coordinateSystem = crs.getCoordinateSystem();
                this.datum = crs.getDatum();
            } else {
                this.datum = this.defaultCRS.datum();
                Integer epsg = this.epsgCandidateCS(Units.DEGREE);
                if (epsg != null) {
                    try {
                        this.coordinateSystem = decoder.getCSAuthorityFactory().createEllipsoidalCS(epsg.toString());
                    }
                    catch (NoSuchAuthorityCodeException e) {
                        this.recoverableException(e);
                    }
                }
            }
        }

        @Override
        void createCS(CSFactory factory, Map<String, ?> properties, CoordinateSystemAxis[] axes) throws FactoryException {
            this.coordinateSystem = axes.length > 2 ? factory.createEllipsoidalCS(properties, axes[0], axes[1], axes[2]) : factory.createEllipsoidalCS(properties, axes[0], axes[1]);
        }

        @Override
        void createCRS(CRSFactory factory, Map<String, ?> properties) throws FactoryException {
            this.referenceSystem = factory.createGeographicCRS(properties, (GeodeticDatum)this.datum, (EllipsoidalCS)this.coordinateSystem);
        }
    }

    private static final class Spherical
    extends Geodetic<SphericalCS> {
        public Spherical() {
            super(3);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) throws FactoryException {
            super.setPredefinedComponents(decoder);
            if (this.isPredefinedCS(Units.DEGREE)) {
                GeocentricCRS crs = this.defaultCRS.spherical();
                if (this.isLongitudeFirst) {
                    crs = DefaultGeocentricCRS.castOrCopy(crs).forConvention(AxesConvention.RIGHT_HANDED);
                }
                this.referenceSystem = crs;
                this.coordinateSystem = (SphericalCS)crs.getCoordinateSystem();
                this.datum = crs.getDatum();
            } else {
                this.datum = this.defaultCRS.datum();
            }
        }

        @Override
        void createCS(CSFactory factory, Map<String, ?> properties, CoordinateSystemAxis[] axes) throws FactoryException {
            if (axes.length > 2) {
                this.coordinateSystem = factory.createSphericalCS(properties, axes[0], axes[1], axes[2]);
            } else if (factory instanceof GeodeticObjectFactory) {
                this.coordinateSystem = ((GeodeticObjectFactory)factory).createSphericalCS(properties, axes[0], axes[1]);
            } else {
                throw new FactoryException("Unsupported factory implementation.");
            }
        }

        @Override
        void createCRS(CRSFactory factory, Map<String, ?> properties) throws FactoryException {
            this.referenceSystem = factory.createGeocentricCRS(properties, (GeodeticDatum)this.datum, (SphericalCS)this.coordinateSystem);
        }
    }

    private static final class Vertical
    extends CRSBuilder<VerticalDatum, VerticalCS> {
        static final int CACHE_INDEX = 1;

        public Vertical() {
            super(VerticalDatum.class, "Mean Sea Level", 1, 1, 1);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) {
            CommonCRS.Vertical predefined;
            Axis axis = this.getFirstAxis();
            Unit<?> unit = axis.getUnit();
            if (Units.METRE.equals(unit)) {
                predefined = AxisDirection.UP.equals(axis.direction) ? CommonCRS.Vertical.MEAN_SEA_LEVEL : CommonCRS.Vertical.DEPTH;
            } else if (Units.HECTOPASCAL.equals(unit)) {
                predefined = CommonCRS.Vertical.BAROMETRIC;
            } else {
                return;
            }
            this.coordinateSystem = predefined.crs().getCoordinateSystem();
        }

        @Override
        void createDatum(DatumFactory factory, Map<String, ?> properties) throws FactoryException {
            this.datum = factory.createVerticalDatum(properties, VerticalDatumType.GEOIDAL);
        }

        @Override
        void createCS(CSFactory factory, Map<String, ?> properties, CoordinateSystemAxis[] axes) throws FactoryException {
            this.coordinateSystem = factory.createVerticalCS(properties, axes[0]);
        }

        @Override
        void createCRS(CRSFactory factory, Map<String, ?> properties) throws FactoryException {
            this.referenceSystem = factory.createVerticalCRS(properties, (VerticalDatum)this.datum, (VerticalCS)this.coordinateSystem);
        }
    }

    private static abstract class Geodetic<CS extends CoordinateSystem>
    extends CRSBuilder<GeodeticDatum, CS> {
        static final int CACHE_INDEX = 0;
        protected CommonCRS defaultCRS;
        protected boolean isLongitudeFirst;

        Geodetic(int minDim) {
            super(GeodeticDatum.class, "GRS 1980", 0, minDim, 3);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) throws FactoryException {
            this.defaultCRS = decoder.convention().defaultHorizontalCRS(false);
        }

        @Override
        final void createDatum(DatumFactory factory, Map<String, ?> properties) throws FactoryException {
            GeodeticDatum template = this.defaultCRS.datum();
            this.datum = factory.createGeodeticDatum(properties, template.getEllipsoid(), template.getPrimeMeridian());
        }

        final boolean isPredefinedCS(Unit<?> expected) {
            Axis axis = this.getFirstAxis();
            Unit<?> unit = axis.getUnit();
            if (unit == null || expected.equals(unit)) {
                this.isLongitudeFirst = AxisDirection.EAST.equals(axis.direction);
                if (this.isLongitudeFirst || AxisDirection.NORTH.equals(axis.direction)) {
                    return true;
                }
            }
            return false;
        }
    }
}

