/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.logging.LogManager;

public class Initializer {
    private static final String PROPERTY = "java.util.logging.FileHandler.pattern";
    private static final String PATTERN = "%p";

    public Initializer() throws IOException {
        String file = System.getProperty("java.util.logging.config.file");
        if (file != null) {
            Path path = Path.of(file, new String[0]).normalize();
            StringBuilder buffer = new StringBuilder(600);
            for (String line : Files.readAllLines(path)) {
                int i;
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                int base = buffer.length();
                buffer.append(line).append('\n');
                if (!line.startsWith(PROPERTY) || (i = buffer.indexOf(PATTERN, base + PROPERTY.length())) < 0) continue;
                Path parent = path;
                int j = Math.min(parent.getNameCount(), 2);
                while (--j >= 0) {
                    parent = parent.getParent();
                }
                String replacement = parent != null ? parent.toString() : ".";
                replacement = replacement.replace(File.separatorChar, '/');
                buffer.replace(i, i + PATTERN.length(), replacement);
            }
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(buffer.toString().getBytes()));
        }
    }
}

