/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.util.concurrent.atomic.AtomicReference;

public class CircularLossyQueue<T> {
    private final AtomicReference<T>[] circularArray;
    private final int maxSize;
    private int currentIndex = -1;
    private boolean isFull = false;

    public CircularLossyQueue(int size) {
        this.circularArray = new AtomicReference[size];
        for (int i = 0; i < size; ++i) {
            this.circularArray[i] = new AtomicReference();
        }
        this.maxSize = size;
    }

    public void push(T newVal) {
        int index = ++this.currentIndex % this.maxSize;
        this.circularArray[index].set(newVal);
        this.isFull = this.isFull || this.currentIndex == this.maxSize;
        this.currentIndex = index;
    }

    public T[] toArray(T[] type) {
        if (type.length > this.maxSize) {
            throw new IllegalArgumentException("Size of array passed in cannot be greater than " + this.maxSize);
        }
        int curIndex = this.currentIndex + this.maxSize;
        for (int k = 0; k < type.length; ++k) {
            int index = (curIndex - k) % this.maxSize;
            type[k] = this.circularArray[index].get();
        }
        return type;
    }

    public T peek() {
        if (this.currentIndex == -1) {
            return null;
        }
        return this.circularArray[this.currentIndex].get();
    }

    public boolean isEmpty() {
        return this.currentIndex == -1;
    }

    public int depth() {
        return this.isFull ? this.maxSize : this.currentIndex + 1;
    }
}

