/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactory;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointCollectionImpl;
import ucar.nc2.ft.point.standard.StandardProfileCollectionImpl;
import ucar.nc2.ft.point.standard.StandardSectionCollectionImpl;
import ucar.nc2.ft.point.standard.StandardStationCollectionImpl;
import ucar.nc2.ft.point.standard.StandardStationProfileCollectionImpl;
import ucar.nc2.ft.point.standard.StandardTrajectoryCollectionImpl;
import ucar.nc2.ft.point.standard.TableAnalyzer;
import ucar.nc2.ft.point.standard.TableConfigurer;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;

public class PointDatasetStandardFactory
implements FeatureDatasetFactory {
    private static Logger log = LoggerFactory.getLogger(PointDatasetStandardFactory.class);
    static boolean showTables = false;

    public static void setDebugFlags(DebugFlags debugFlags) {
        showTables = debugFlags.isSet("PointDatasetStandardFactory/showTables");
    }

    @Override
    public Object isMine(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        TableAnalyzer analyser;
        if (wantFeatureType == null) {
            wantFeatureType = FeatureType.ANY_POINT;
        }
        if (wantFeatureType != FeatureType.ANY_POINT && !wantFeatureType.isPointFeatureType()) {
            return null;
        }
        TableConfigurer tc = TableAnalyzer.getTableConfigurer(wantFeatureType, ds);
        if (tc == null) {
            boolean hasTime = false;
            boolean hasLat = false;
            boolean hasLon = false;
            for (CoordinateAxis axis : ds.getCoordinateAxes()) {
                if (axis.getAxisType() == AxisType.Time) {
                    hasTime = true;
                }
                if (axis.getAxisType() == AxisType.Lat) {
                    hasLat = true;
                }
                if (axis.getAxisType() != AxisType.Lon) continue;
                hasLon = true;
            }
            if (!(hasTime && hasLon && hasLat)) {
                errlog.format("PointDataset must have lat,lon,time", new Object[0]);
                return null;
            }
        } else if (showTables) {
            System.out.printf("TableConfigurer = %s%n", tc.getClass().getName());
        }
        if ((analyser = TableAnalyzer.factory(tc, wantFeatureType, ds)) == null) {
            return null;
        }
        if (!analyser.featureTypeOk(wantFeatureType, errlog)) {
            return null;
        }
        return analyser;
    }

    @Override
    public FeatureDataset open(FeatureType wantFeatureType, NetcdfDataset ncd, Object analyser, CancelTask task, Formatter errlog) throws IOException {
        if (analyser == null) {
            analyser = TableAnalyzer.factory(null, wantFeatureType, ncd);
        }
        return new PointDatasetStandard(wantFeatureType, (TableAnalyzer)analyser, ncd, errlog);
    }

    @Override
    public FeatureType[] getFeatureType() {
        return new FeatureType[]{FeatureType.ANY_POINT};
    }

    static class PointDatasetStandard
    extends PointDatasetImpl {
        private TableAnalyzer analyser;

        PointDatasetStandard(FeatureType wantFeatureType, TableAnalyzer analyser, NetcdfDataset ds, Formatter errlog) throws IOException {
            super(ds, null);
            this.parseInfo.format(" PointFeatureDatasetImpl=%s%n", this.getClass().getName());
            this.analyser = analyser;
            ArrayList<FeatureCollection> featureCollections = new ArrayList<FeatureCollection>();
            for (NestedTable flatTable : analyser.getFlatTables()) {
                DateUnit timeUnit = null;
                try {
                    timeUnit = flatTable.getTimeUnit();
                }
                catch (Exception e) {
                    if (null != errlog) {
                        errlog.format("%s%n", e.getMessage());
                    }
                    try {
                        timeUnit = new DateUnit("seconds since 1970-01-01");
                    }
                    catch (Exception e1) {
                        log.error("Illegal time units", e1);
                    }
                }
                String altUnits = flatTable.getAltUnits();
                this.dataVariables = new ArrayList<VariableSimpleIF>(flatTable.getDataVariables());
                this.featureType = flatTable.getFeatureType();
                if (flatTable.getFeatureType() == FeatureType.POINT) {
                    featureCollections.add(new StandardPointCollectionImpl(flatTable, timeUnit, altUnits));
                    continue;
                }
                if (flatTable.getFeatureType() == FeatureType.PROFILE) {
                    featureCollections.add(new StandardProfileCollectionImpl(flatTable, timeUnit, altUnits));
                    continue;
                }
                if (flatTable.getFeatureType() == FeatureType.STATION) {
                    featureCollections.add(new StandardStationCollectionImpl(flatTable, timeUnit, altUnits));
                    continue;
                }
                if (flatTable.getFeatureType() == FeatureType.STATION_PROFILE) {
                    featureCollections.add(new StandardStationProfileCollectionImpl(flatTable, timeUnit, altUnits));
                    continue;
                }
                if (flatTable.getFeatureType() == FeatureType.SECTION) {
                    featureCollections.add(new StandardSectionCollectionImpl(flatTable, timeUnit, altUnits));
                    continue;
                }
                if (flatTable.getFeatureType() != FeatureType.TRAJECTORY) continue;
                featureCollections.add(new StandardTrajectoryCollectionImpl(flatTable, timeUnit, altUnits));
            }
            if (featureCollections.size() == 0) {
                throw new IllegalStateException("No feature collections found");
            }
            this.setPointFeatureCollection(featureCollections);
        }

        @Override
        public void getDetailInfo(Formatter sf) {
            super.getDetailInfo(sf);
            this.analyser.getDetailInfo(sf);
        }

        @Override
        public FeatureType getFeatureType() {
            return this.featureType;
        }

        @Override
        public String getImplementationName() {
            if (this.analyser != null) {
                return this.analyser.getImplementationName();
            }
            return super.getImplementationName();
        }

        TableAnalyzer getTableAnalyzer() {
            return this.analyser;
        }
    }
}

