/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribLevelType;
import ucar.nc2.grib.GribResourceReader;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;

public class NcepTables
extends Grib1Customizer {
    private static final Logger logger = LoggerFactory.getLogger(NcepTables.class);
    private static Map<Integer, String> genProcessMap;
    private static Map<Integer, GribLevelType> levelTypesMap;

    NcepTables(Grib1ParamTables tables) {
        super(7, tables);
    }

    protected NcepTables(int center, Grib1ParamTables tables) {
        super(center, tables);
    }

    @Override
    public GribStatType getStatType(int timeRangeIndicator) {
        if (timeRangeIndicator < 128) {
            return super.getStatType(timeRangeIndicator);
        }
        switch (timeRangeIndicator) {
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                return GribStatType.Average;
            }
            case 134: {
                return GribStatType.RootMeanSquare;
            }
            case 135: 
            case 136: {
                return GribStatType.StandardDeviation;
            }
        }
        return null;
    }

    @Override
    public String getTimeTypeName(int timeRangeIndicator) {
        if (timeRangeIndicator < 128) {
            return super.getTimeTypeName(timeRangeIndicator);
        }
        switch (timeRangeIndicator) {
            case 128: {
                return "Average of forecast accumulations at 24 hour intervals, period = (RT + P1) to (RT + P2)";
            }
            case 129: {
                return "Average of successive forecast accumulations, period = (RT + P1) to (RT + P2)";
            }
            case 130: {
                return "Average of forecast averages at 24 hour intervals, period = (RT + P1) to (RT + P2)";
            }
            case 131: {
                return "Average of successive forecast averages, period = (RT + P1) to (RT + P2)";
            }
            case 132: {
                return "Climatological Average of N analyses, each a year apart, starting from initial time R and for the period from R+P1 to R+P2.";
            }
            case 133: {
                return "Climatological Average of N forecasts, each a year apart, starting from initial time R and for the period from R+P1 to R+P2.";
            }
            case 134: {
                return "Climatological Root Mean Square difference between N forecasts and their verifying analyses, each a year apart, starting with initial time R and for the period from R+P1 to R+P2.";
            }
            case 135: {
                return "Climatological Standard Deviation of N forecasts from the mean of the same N forecasts, for forecasts one year apart. ";
            }
            case 136: {
                return "Climatological Standard Deviation of N analyses from the mean of the same N analyses, for analyses one year apart.";
            }
            case 137: {
                return "Average of forecast accumulations at 6 hour intervals, period = (RT + P1) to (RT + P2)";
            }
            case 138: {
                return "Average of forecast averages at 6 hour intervals, period = (RT + P1) to (RT + P2)";
            }
            case 139: {
                return "Average of forecast accumulations at 12 hour intervals, period = (RT + P1) to (RT + P2)";
            }
            case 140: {
                return "Average of forecast averages at 12 hour intervals, period = (RT + P1) to (RT + P2)";
            }
        }
        return null;
    }

    @Override
    public String getGeneratingProcessName(int genProcess) {
        if (genProcessMap == null) {
            genProcessMap = NcepTables.getNcepGenProcess();
        }
        if (genProcessMap == null) {
            return null;
        }
        return genProcessMap.get(genProcess);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<Integer, String> getNcepGenProcess() {
        if (genProcessMap != null) {
            return genProcessMap;
        }
        String path = "resources/grib1/ncep/ncepTableA.xml";
        try (InputStream is = GribResourceReader.getInputStream(path);){
            if (is == null) {
                logger.error("Cant find NCEP Table 1 = " + path);
                Map<Integer, String> map2 = null;
                return map2;
            }
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            HashMap<Integer, String> result = new HashMap<Integer, String>(200);
            List<Element> params = root.getChildren("parameter");
            for (Element elem1 : params) {
                int code = Integer.parseInt(elem1.getAttributeValue("code"));
                String desc = elem1.getChildText("description");
                result.put(code, desc);
            }
            Map<Integer, String> map = Collections.unmodifiableMap(result);
            return map;
        }
        catch (IOException ioe) {
            logger.error("Cant read NCEP Table 1 = " + path, ioe);
            return null;
        }
        catch (JDOMException e) {
            logger.error("Cant parse NCEP Table 1 = " + path, e);
            return null;
        }
    }

    @Override
    protected VertCoord.VertUnit makeVertUnit(int code) {
        GribLevelType lt = this.getLevelType(code);
        return lt != null ? lt : super.makeVertUnit(code);
    }

    @Override
    public String getLevelNameShort(int code) {
        GribLevelType lt = this.getLevelType(code);
        return lt == null ? super.getLevelNameShort(code) : lt.getAbbrev();
    }

    @Override
    public String getLevelDescription(int code) {
        GribLevelType lt = this.getLevelType(code);
        return lt == null ? super.getLevelDescription(code) : lt.getDesc();
    }

    @Override
    public String getLevelUnits(int code) {
        GribLevelType lt = this.getLevelType(code);
        return lt == null ? super.getLevelUnits(code) : lt.getUnits();
    }

    @Override
    public boolean isLayer(int code) {
        GribLevelType lt = this.getLevelType(code);
        return lt == null ? super.isLayer(code) : lt.isLayer();
    }

    @Override
    public boolean isPositiveUp(int code) {
        GribLevelType lt = this.getLevelType(code);
        return lt == null ? super.isPositiveUp(code) : lt.isPositiveUp();
    }

    @Override
    public String getLevelDatum(int code) {
        GribLevelType lt = this.getLevelType(code);
        return lt == null ? super.getLevelDatum(code) : lt.getDatum();
    }

    private GribLevelType getLevelType(int code) {
        if (code < 129) {
            return null;
        }
        if (levelTypesMap == null) {
            levelTypesMap = this.readTable3("resources/grib1/ncep/ncepTable3.xml");
        }
        if (levelTypesMap == null) {
            return null;
        }
        return levelTypesMap.get(code);
    }
}

