/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import java.util.SortedMap;
import java.util.TreeMap;
import net.jcip.annotations.Immutable;
import ucar.units.BaseQuantity;
import ucar.units.BaseUnit;
import ucar.units.NameException;
import ucar.units.UnitName;

@Immutable
public final class UnknownUnit
extends BaseUnit {
    private static final long serialVersionUID = 1L;
    private static final SortedMap<String, UnknownUnit> map = new TreeMap<String, UnknownUnit>();

    private UnknownUnit(String name) throws NameException {
        super(UnitName.newUnitName(name, null, name), BaseQuantity.UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UnknownUnit create(String name) throws NameException {
        UnknownUnit unit;
        name = name.toLowerCase();
        SortedMap<String, UnknownUnit> sortedMap = map;
        synchronized (sortedMap) {
            unit = (UnknownUnit)map.get(name);
            if (unit == null) {
                unit = new UnknownUnit(name);
                map.put(unit.getName(), unit);
                map.put(unit.getPlural(), unit);
            }
        }
        return unit;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UnknownUnit)) {
            return false;
        }
        UnknownUnit that = (UnknownUnit)object;
        return this.getName().equalsIgnoreCase(that.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().toLowerCase().hashCode();
    }

    @Override
    public boolean isDimensionless() {
        return false;
    }
}

