/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.RowActionBase;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.persist.PersistentStore;

public class TransactionManagerMVCC
extends TransactionManagerCommon
implements TransactionManager {
    HsqlDeque<RowAction[]> committedTransactions = new HsqlDeque();
    LongDeque committedTransactionSCNs = new LongDeque();
    boolean isLockedMode;
    Session catalogWriteSession;
    long lockTxTs;
    long lockSessionId;
    long unlockTxTs;
    long unlockSessionId;
    int redoCount = 0;

    public TransactionManagerMVCC(Database database) {
        super(database);
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.txModel = 2;
    }

    @Override
    public long getSystemChangeNumber() {
        return this.systemChangeNumber.get();
    }

    @Override
    public void setSystemChangeNumber(long l) {
        this.systemChangeNumber.set(l);
    }

    @Override
    public boolean isMVRows() {
        return true;
    }

    @Override
    public boolean isMVCC() {
        return true;
    }

    @Override
    public boolean is2PL() {
        return false;
    }

    @Override
    public int getTransactionControl() {
        return 2;
    }

    @Override
    public void setTransactionControl(Session session, int n) {
        super.setTransactionControl(session, n);
    }

    @Override
    public void completeActions(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareCommitActions(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            Object object;
            int n;
            int n2 = session.rowActionList.size();
            for (n = 0; n < n2; ++n) {
                object = session.rowActionList.get(n);
                if (((RowAction)object).canCommit(session)) continue;
                boolean bl = false;
                return bl;
            }
            session.actionSCN = this.getNextSystemChangeNumber();
            for (n = 0; n < n2; ++n) {
                object = session.rowActionList.get(n);
                ((RowAction)object).prepareCommit(session);
            }
            for (n = 0; n < session.actionSet.size(); ++n) {
                object = session.actionSet.get((int)n).session;
                ((Session)object).abortTransaction = true;
            }
            n = 1;
            return n != 0;
        }
        finally {
            this.writeLock.unlock();
            session.actionSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            Object object;
            int n;
            int n2 = session.rowActionList.size();
            for (n = 0; n < n2; ++n) {
                object = session.rowActionList.get(n);
                if (object.canCommit(session)) continue;
                boolean bl = false;
                return bl;
            }
            session.transactionEndSCN = session.actionSCN = this.getNextSystemChangeNumber();
            this.endTransaction(session);
            for (n = 0; n < n2; ++n) {
                object = session.rowActionList.get(n);
                object.commit(session);
            }
            for (n = 0; n < session.actionSet.size(); ++n) {
                object = session.actionSet.get((int)n).session;
                object.abortTransaction = true;
            }
            this.adjustLobUsage(session);
            this.persistCommit(session);
            n = session.rowActionList.size();
            if (n > n2) {
                object = session.rowActionList.getArray();
                this.mergeTransaction((RowAction[])object, n2, n, session.actionSCN);
                this.finaliseRows(session, (Object[])object, n2, n);
                session.rowActionList.setSize(n2);
            }
            if (session == this.lobSession || this.getFirstLiveTransactionTimestamp() > session.actionSCN) {
                object = session.rowActionList.getArray();
                this.mergeTransaction((RowAction[])object, 0, n2, session.actionSCN);
                this.finaliseRows(session, (Object[])object, 0, n2);
            } else if (session.rowActionList.size() > 0) {
                object = session.rowActionList.toArray(RowAction.emptyArray);
                this.addToCommittedQueue(session, (RowAction[])object);
            }
            this.endTransactionTPL(session);
            session.isTransaction = false;
            this.countDownLatches(session);
        }
        finally {
            session.actionSet.clear();
            this.writeLock.unlock();
        }
        return true;
    }

    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndSCN = session.actionSCN = this.getNextSystemChangeNumber();
            this.rollbackPartial(session, 0, session.transactionSCN);
            this.endTransaction(session);
            session.logSequences();
            this.endTransactionTPL(session);
            session.isTransaction = false;
            this.countDownLatches(session);
            session.sessionData.newLobFloor = -1L;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int n) {
        long l = session.sessionContext.savepointTimestamps.get(n);
        Integer n2 = session.sessionContext.savepoints.get(n);
        int n3 = n2;
        while (session.sessionContext.savepoints.size() > n + 1) {
            session.sessionContext.savepoints.removeEntry(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, n3, l);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionStartSCN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackPartial(Session session, int n, long l) {
        int n2 = session.rowActionList.size();
        if (n == n2) {
            return;
        }
        for (int i = n2 - 1; i >= n; --i) {
            RowAction rowAction = session.rowActionList.get(i);
            if (rowAction == null || rowAction.type == 0 || rowAction.type == 3) continue;
            Row row = rowAction.memoryRow;
            if (row == null) {
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            if (row == null) continue;
            this.writeLock.lock();
            try {
                rowAction.rollback(session, l);
                int n3 = rowAction.mergeRollback(session, l);
                if (rowAction.type == 3) {
                    if (rowAction.deleteComplete) continue;
                    rowAction.deleteComplete = true;
                }
                rowAction.store.rollbackRow(session, row, n3, this.txModel);
                continue;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        session.rowActionList.setSize(n);
    }

    @Override
    public RowAction addDeleteAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = persistentStore.addDeleteActionToRow(session, row, nArray, true);
        if (table.isTemp) {
            persistentStore.delete(session, row);
            row.rowAction = null;
            if (table.persistenceScope == 20) {
                return rowAction;
            }
        }
        Session session2 = null;
        boolean bl = true;
        if (rowAction == null) {
            this.writeLock.lock();
            try {
                this.rollbackAction(session);
                if (session.isolationLevel == 4 || session.isolationLevel == 8) {
                    session.actionSet.clear();
                    session.redoAction = false;
                    session.abortTransaction = session.txConflictRollback;
                    throw Error.error(4871);
                }
                if (row.rowAction != null && row.rowAction.isDeleted()) {
                    session.actionSet.clear();
                    session.redoAction = true;
                    ++this.redoCount;
                    throw Error.error(4871);
                }
                boolean bl2 = bl = !session.actionSet.isEmpty();
                if (bl) {
                    session2 = session.actionSet.get((int)0).session;
                    session.actionSet.clear();
                    if (session2 != null) {
                        bl = this.checkDeadlock(session, session2);
                    }
                }
                if (bl) {
                    session.redoAction = true;
                    if (session2 != null) {
                        session2.waitingSessions.add(session);
                        session.waitedSessions.add(session2);
                        session.latch.setCount(session.waitedSessions.size());
                    }
                    ++this.redoCount;
                } else {
                    session.redoAction = false;
                    session.abortTransaction = session.txConflictRollback;
                }
                throw Error.error(4871);
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
        }
        session.rowActionList.add(rowAction);
        return rowAction;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = row.rowAction;
        Session session2 = null;
        boolean bl = false;
        boolean bl2 = true;
        HsqlException hsqlException = null;
        if (rowAction == null) {
            throw Error.runtimeError(458, "TXManager - null insert action ");
        }
        try {
            persistentStore.indexRow(session, row);
        }
        catch (HsqlException hsqlException2) {
            if (session.actionSet.isEmpty()) {
                throw hsqlException2;
            }
            bl = true;
            hsqlException = hsqlException2;
        }
        if (!bl) {
            if (table.isTemp) {
                row.rowAction = null;
                if (table.persistenceScope == 20) {
                    return;
                }
            }
            session.rowActionList.add(rowAction);
            return;
        }
        this.writeLock.lock();
        try {
            this.rollbackAction(session);
            RowActionBase rowActionBase = session.actionSet.get(0);
            session2 = rowActionBase.session;
            session.actionSet.clear();
            if (rowActionBase.commitSCN != 0L) {
                bl2 = false;
            }
            switch (session.isolationLevel) {
                case 4: 
                case 8: {
                    bl = false;
                    break;
                }
                default: {
                    bl = this.checkDeadlock(session, session2);
                }
            }
            if (bl) {
                session.redoAction = true;
                if (bl2) {
                    session2.waitingSessions.add(session);
                    session.waitedSessions.add(session2);
                    session.latch.setCount(session.waitedSessions.size());
                }
                ++this.redoCount;
            } else {
                session.abortTransaction = session.txConflictRollback;
                session.redoAction = false;
            }
            throw Error.error(hsqlException, 4871, null);
        }
        catch (Throwable throwable) {
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public boolean canRead(Session session, PersistentStore persistentStore, Row row, int n, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            return true;
        }
        if (rowAction.table.isTemp) {
            return true;
        }
        if (n == 0) {
            return rowAction.canRead(session, 0, nArray);
        }
        if (n == 2) {
            return rowAction.canRead(session, 0, nArray);
        }
        return rowAction.canRead(session, n, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCommittedQueue(Session session, RowAction[] rowActionArray) {
        LongDeque longDeque = this.committedTransactionSCNs;
        synchronized (longDeque) {
            this.committedTransactions.addLast(rowActionArray);
            this.committedTransactionSCNs.addLast(session.actionSCN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeExpiredTransactions(Session session) {
        long l = this.getFirstLiveTransactionTimestamp();
        while (true) {
            Object[] objectArray;
            long l2;
            LongDeque longDeque = this.committedTransactionSCNs;
            synchronized (longDeque) {
                if (this.committedTransactionSCNs.isEmpty()) {
                    break;
                }
                l2 = this.committedTransactionSCNs.getFirst();
                if (l2 >= l) {
                    break;
                }
                this.committedTransactionSCNs.removeFirst();
                objectArray = this.committedTransactions.removeFirst();
            }
            this.mergeTransaction((RowAction[])objectArray, 0, objectArray.length, l2);
            this.finaliseRows(session, objectArray, 0, objectArray.length);
        }
    }

    @Override
    public void beginTransaction(Session session) {
        this.writeLock.lock();
        try {
            if (!session.isTransaction) {
                this.beginTransactionCommon(session);
                this.liveTransactionSCNs.addLast(session.transactionSCN);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void beginAction(Session session, Statement statement) {
        if (session.isTransaction) {
            return;
        }
        if (statement == null) {
            return;
        }
        this.writeLock.lock();
        try {
            if (this.hasExpired) {
                session.redoAction = true;
                return;
            }
            if (session.abortTransaction) {
                return;
            }
            session.isPreTransaction = true;
            if (!this.isLockedMode && !statement.isCatalogLock(this.txModel)) {
                return;
            }
            this.beginActionTPL(session, statement);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void beginActionResume(Session session) {
        this.writeLock.lock();
        try {
            Statement statement = session.sessionContext.currentStatement;
            statement = this.updateCurrentStatement(session, statement);
            if (session.sessionContext.invalidStatement) {
                return;
            }
            if (session.isTransaction) {
                session.actionStartSCN = session.actionSCN = this.getNextSystemChangeNumber();
            } else {
                this.beginTransactionCommon(session);
                this.liveTransactionSCNs.addLast(session.transactionSCN);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void endTransaction(Session session) {
        long l = session.transactionSCN;
        int n = this.liveTransactionSCNs.indexOf(l);
        if (n >= 0) {
            this.transactionCount.decrementAndGet();
            this.liveTransactionSCNs.remove(n);
            this.mergeExpiredTransactions(session);
        }
    }

    private void countDownLatches(Session session) {
        for (int i = 0; i < session.waitingSessions.size(); ++i) {
            Session session2 = session.waitingSessions.get(i);
            session2.waitedSessions.remove(session);
            session2.latch.setCount(session2.waitedSessions.size());
        }
        session.waitedSessions.clear();
        session.waitingSessions.clear();
    }

    @Override
    void endTransactionTPL(Session session) {
        Session session2;
        int n;
        if (this.catalogWriteSession != session) {
            return;
        }
        Session session3 = null;
        for (n = 0; n < session.waitingSessions.size(); ++n) {
            session2 = session.waitingSessions.get(n);
            Statement statement = session2.sessionContext.currentStatement;
            if (statement == null || !statement.isCatalogLock(this.txModel)) continue;
            session3 = session2;
            break;
        }
        if (session3 == null) {
            this.catalogWriteSession = null;
            this.isLockedMode = false;
        } else {
            for (n = 0; n < session.waitingSessions.size(); ++n) {
                session2 = session.waitingSessions.get(n);
                if (session2 == session3) continue;
                session2.waitedSessions.add(session3);
                session3.waitingSessions.add(session2);
                session2.latch.setCount(session2.waitedSessions.size());
            }
            this.catalogWriteSession = session3;
        }
        this.unlockTxTs = session.actionSCN;
        this.unlockSessionId = session.getId();
    }

    void beginActionTPL(Session session, Statement statement) {
        if (session == this.catalogWriteSession) {
            return;
        }
        session.tempSet.clear();
        if (statement.isCatalogLock(this.txModel) && !this.isLockedMode) {
            this.catalogWriteSession = session;
            this.isLockedMode = true;
            this.lockTxTs = session.actionSCN;
            this.lockSessionId = session.getId();
            this.getTransactionAndPreSessions(session);
            if (!session.tempSet.isEmpty()) {
                session.waitedSessions.addAll(session.tempSet);
                this.setWaitingSessionTPL(session);
            }
            return;
        }
        if (!this.isLockedMode) {
            return;
        }
        if (statement.getTableNamesForWrite().length > 0 ? statement.getTableNamesForWrite()[0].schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME : statement.getTableNamesForRead().length > 0 && statement.getTableNamesForRead()[0].schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
            return;
        }
        if (session.waitingSessions.contains(this.catalogWriteSession)) {
            return;
        }
        if (this.catalogWriteSession.waitingSessions.add(session)) {
            session.waitedSessions.add(this.catalogWriteSession);
            session.latch.setCount(session.waitedSessions.size());
        }
    }

    @Override
    public void resetSession(Session session, Session session2, long l, int n) {
        super.resetSession(session, session2, l, n);
    }
}

