/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.transaction;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import javax.naming.InitialContext;
import org.apache.batchee.container.exception.TransactionManagementException;
import org.apache.batchee.spi.TransactionManagerAdapter;

public class JTAUserTransactionAdapter
implements TransactionManagerAdapter {
    private static final String[] JNDI_LOCS = new String[]{"java:comp/TransactionManager", "jakarta.transaction.TransactionManager", "java:/TransactionManager", "java:/DefaultDomain/TransactionManager", "java:comp/pm/TransactionManager", "java:appserver/TransactionManager", "java:pm/TransactionManager", "aries:services/jakarta.transaction.TransactionManager"};
    private static final String[] METHODS = new String[]{"org.openejb.OpenEJB.getTransactionManager", "com.arjuna.jta.JTA_TransactionManager.transactionManager", "com.bluestone.jta.SaTransactionManagerFactory.SaGetTransactionManager", "com.sun.jts.jta.TransactionManagerImpl.getTransactionManagerImpl", "com.inprise.visitransact.jta.TransactionManagerImpl.getTransactionManagerImpl", "com.ibm.tx.jta.TransactionManagerFactory.getTransactionManager"};
    protected TransactionManager mgr = null;

    public JTAUserTransactionAdapter() {
        for (String jndiLoc : JNDI_LOCS) {
            try {
                this.mgr = (TransactionManager)TransactionManager.class.cast(new InitialContext().lookup(jndiLoc));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.mgr != null) break;
        }
        if (this.mgr == null) {
            for (String method : METHODS) {
                String clazz = method.substring(0, method.lastIndexOf(46));
                String methodName = method.substring(method.lastIndexOf(46) + 1);
                try {
                    this.mgr = (TransactionManager)TransactionManager.class.cast(Thread.currentThread().getContextClassLoader().loadClass(clazz).getMethod(methodName, new Class[0]).invoke(null, new Object[0]));
                    if (this.mgr == null) continue;
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (this.mgr == null) {
            throw new TransactionManagementException("no transaction manager found");
        }
    }

    @Override
    public void begin() throws TransactionManagementException {
        try {
            this.mgr.begin();
        }
        catch (NotSupportedException e) {
            throw new TransactionManagementException(e);
        }
        catch (SystemException e) {
            throw new TransactionManagementException(e);
        }
    }

    public Transaction beginSuspending() throws TransactionManagementException {
        try {
            Transaction t = this.mgr.getTransaction() != null ? this.mgr.suspend() : null;
            this.mgr.begin();
            return t;
        }
        catch (NotSupportedException e) {
            throw new TransactionManagementException(e);
        }
        catch (SystemException e) {
            throw new TransactionManagementException(e);
        }
    }

    public void resume(Transaction transaction) {
        try {
            this.mgr.resume(transaction);
        }
        catch (InvalidTransactionException e) {
            throw new TransactionManagementException(e);
        }
        catch (SystemException e) {
            throw new TransactionManagementException(e);
        }
    }

    @Override
    public void commit() throws TransactionManagementException {
        try {
            this.mgr.commit();
        }
        catch (SecurityException e) {
            throw new TransactionManagementException(e);
        }
        catch (IllegalStateException e) {
            throw new TransactionManagementException(e);
        }
        catch (RollbackException e) {
            throw new TransactionManagementException(e);
        }
        catch (HeuristicMixedException e) {
            throw new TransactionManagementException(e);
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionManagementException(e);
        }
        catch (SystemException e) {
            throw new TransactionManagementException(e);
        }
    }

    @Override
    public void rollback() throws TransactionManagementException {
        try {
            this.mgr.rollback();
        }
        catch (IllegalStateException e) {
            throw new TransactionManagementException(e);
        }
        catch (SecurityException e) {
            throw new TransactionManagementException(e);
        }
        catch (SystemException e) {
            throw new TransactionManagementException(e);
        }
    }

    @Override
    public int getStatus() throws TransactionManagementException {
        try {
            return this.mgr.getStatus();
        }
        catch (SystemException e) {
            throw new TransactionManagementException(e);
        }
    }

    @Override
    public void setRollbackOnly() throws TransactionManagementException {
        try {
            this.mgr.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            throw new TransactionManagementException(e);
        }
        catch (SystemException e) {
            throw new TransactionManagementException(e);
        }
    }

    @Override
    public void setTransactionTimeout(int seconds) throws TransactionManagementException {
        try {
            this.mgr.setTransactionTimeout(seconds);
        }
        catch (SystemException e) {
            throw new TransactionManagementException(e);
        }
    }
}

