/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.network.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.net.internal.InetSocketAddressUtil;
import io.opentelemetry.instrumentation.api.instrumenter.network.NetworkAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.AddressAndPortExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.NetworkAttributes;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.SemanticAttributes;
import java.net.InetSocketAddress;
import java.util.Locale;
import javax.annotation.Nullable;

public final class InternalNetworkAttributesExtractor<REQUEST, RESPONSE> {
    private final NetworkAttributesGetter<REQUEST, RESPONSE> getter;
    private final AddressAndPortExtractor<REQUEST> logicalPeerAddressAndPortExtractor;
    private final boolean captureProtocolAttributes;
    private final boolean captureLocalSocketAttributes;
    private final boolean captureOldPeerDomainAttribute;
    private final boolean emitStableUrlAttributes;
    private final boolean emitOldHttpAttributes;

    public InternalNetworkAttributesExtractor(NetworkAttributesGetter<REQUEST, RESPONSE> getter, AddressAndPortExtractor<REQUEST> logicalPeerAddressAndPortExtractor, boolean captureProtocolAttributes, boolean captureLocalSocketAttributes, boolean captureOldPeerDomainAttribute, boolean emitStableUrlAttributes, boolean emitOldHttpAttributes) {
        this.getter = getter;
        this.logicalPeerAddressAndPortExtractor = logicalPeerAddressAndPortExtractor;
        this.captureProtocolAttributes = captureProtocolAttributes;
        this.captureLocalSocketAttributes = captureLocalSocketAttributes;
        this.captureOldPeerDomainAttribute = captureOldPeerDomainAttribute;
        this.emitStableUrlAttributes = emitStableUrlAttributes;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
    }

    public void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response) {
        String peerAddress;
        String localAddress;
        String protocolName = InternalNetworkAttributesExtractor.lowercase(this.getter.getNetworkProtocolName(request, response));
        String protocolVersion = InternalNetworkAttributesExtractor.lowercase(this.getter.getNetworkProtocolVersion(request, response));
        if (this.emitStableUrlAttributes && this.captureProtocolAttributes) {
            String transport = InternalNetworkAttributesExtractor.lowercase(this.getter.getNetworkTransport(request, response));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NETWORK_TRANSPORT, (Object)transport);
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NETWORK_TYPE, (Object)InternalNetworkAttributesExtractor.lowercase(this.getter.getNetworkType(request, response)));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NETWORK_PROTOCOL_NAME, (Object)protocolName);
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NETWORK_PROTOCOL_VERSION, (Object)protocolVersion);
        }
        if (this.emitOldHttpAttributes) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_PROTOCOL_NAME, (Object)protocolName);
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_PROTOCOL_VERSION, (Object)protocolVersion);
        }
        if ((localAddress = this.getter.getNetworkLocalAddress(request, response)) != null) {
            Integer localPort;
            if (this.emitStableUrlAttributes && this.captureLocalSocketAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetworkAttributes.NETWORK_LOCAL_ADDRESS, (Object)localAddress);
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_HOST_ADDR, (Object)localAddress);
            }
            if ((localPort = this.getter.getNetworkLocalPort(request, response)) != null && localPort > 0) {
                if (this.emitStableUrlAttributes && this.captureLocalSocketAttributes) {
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetworkAttributes.NETWORK_LOCAL_PORT, (Object)localPort);
                }
                if (this.emitOldHttpAttributes) {
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_HOST_PORT, (Object)localPort);
                }
            }
        }
        if ((peerAddress = this.getter.getNetworkPeerAddress(request, response)) != null) {
            InetSocketAddress peerSocketAddress;
            Integer peerPort;
            if (this.emitStableUrlAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetworkAttributes.NETWORK_PEER_ADDRESS, (Object)peerAddress);
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_PEER_ADDR, (Object)peerAddress);
            }
            if ((peerPort = this.getter.getNetworkPeerPort(request, response)) != null && peerPort > 0) {
                if (this.emitStableUrlAttributes) {
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetworkAttributes.NETWORK_PEER_PORT, (Object)peerPort);
                }
                if (this.emitOldHttpAttributes) {
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_PEER_PORT, (Object)peerPort);
                }
            }
            if (this.emitOldHttpAttributes && this.captureOldPeerDomainAttribute && (peerSocketAddress = this.getter.getNetworkPeerInetSocketAddress(request, response)) != null) {
                String peerSocketDomain = InetSocketAddressUtil.getDomainName(peerSocketAddress);
                String logicalPeerAddress = this.logicalPeerAddressAndPortExtractor.extract(request).address;
                if (peerSocketDomain != null && !peerSocketDomain.equals(logicalPeerAddress)) {
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_PEER_NAME, (Object)peerSocketDomain);
                }
            }
        }
    }

    @Nullable
    private static String lowercase(@Nullable String str) {
        return str == null ? null : str.toLowerCase(Locale.ROOT);
    }
}

