/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.manager.NamedXAResource;

public class WrapperNamedXAResource
implements NamedXAResource {
    protected static Logger log = Logger.getLogger(WrapperNamedXAResource.class.getName());
    private final XAResource xaResource;
    private final String name;

    public WrapperNamedXAResource(XAResource xaResource, String name) {
        if (xaResource == null) {
            throw new NullPointerException("No XAResource supplied.  XA support may not be configured properly");
        }
        if (name == null) {
            throw new NullPointerException("No name supplied. Resource adapter not properly configured");
        }
        this.xaResource = xaResource;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Commit called on XAResource " + this.getName() + "\n Xid: " + xid + "\n onePhase:" + onePhase);
        }
        this.xaResource.commit(xid, onePhase);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "End called on XAResource " + this.getName() + "\n Xid: " + xid + "\n flags:" + this.decodeFlags(flags));
        }
        this.xaResource.end(xid, flags);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Forget called on XAResource " + this.getName() + "\n Xid: " + xid);
        }
        this.xaResource.forget(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource other) throws XAException {
        if (other instanceof WrapperNamedXAResource) {
            return this.xaResource.isSameRM(((WrapperNamedXAResource)other).xaResource);
        }
        return false;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Prepare called on XAResource " + this.getName() + "\n Xid: " + xid);
        }
        return this.xaResource.prepare(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Recover called on XAResource " + this.getName() + "\n flags: " + this.decodeFlags(flag));
        }
        return this.xaResource.recover(flag);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Rollback called on XAResource " + this.getName() + "\n Xid: " + xid);
        }
        this.xaResource.rollback(xid);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xaResource.setTransactionTimeout(seconds);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Start called on XAResource " + this.getName() + "\n Xid: " + xid + "\n flags:" + this.decodeFlags(flags));
        }
        this.xaResource.start(xid, flags);
    }

    private String decodeFlags(int flags) {
        if (flags == 0) {
            return " TMNOFLAGS";
        }
        StringBuilder b = new StringBuilder();
        this.decodeFlag(flags, b, 0x800000, " TMENDRSCAN");
        this.decodeFlag(flags, b, 0x20000000, " TMFAIL");
        this.decodeFlag(flags, b, 0x200000, " TMJOIN");
        this.decodeFlag(flags, b, 0x40000000, " TMONEPHASE");
        this.decodeFlag(flags, b, 0x8000000, " TMRESUME");
        this.decodeFlag(flags, b, 0x1000000, " TMSTARTRSCAN");
        this.decodeFlag(flags, b, 0x4000000, " TMSUCCESS");
        this.decodeFlag(flags, b, 0x2000000, " TMSUSPEND");
        if (flags != 0) {
            b.append(" remaining: ").append(flags);
        }
        return b.toString();
    }

    private void decodeFlag(int flags, StringBuilder b, int flag, String flagName) {
        if ((flags & flag) == flag) {
            b.append(flagName);
            flags ^= flag;
        }
    }
}

