/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.security;

import io.smallrye.openapi.api.models.security.SecurityRequirementImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class SecurityRequirementIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<SecurityRequirement, V, A, O, AB, OB> {
    private static final String PROP_NAME = "name";
    private static final String PROP_SCOPES = "scopes";

    public SecurityRequirementIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.SECURITY_REQUIREMENT, Names.create(SecurityRequirement.class));
    }

    public List<SecurityRequirement> readList(AnnotationTarget target) {
        return this.readList((V)this.getRepeatableAnnotations(target));
    }

    public List<SecurityRequirement> readList(AnnotationValue annotations) {
        return Optional.ofNullable(annotations).map(AnnotationValue::asNestedArray).map(this::readList).orElse(null);
    }

    public List<SecurityRequirement> readList(AnnotationInstance[] annotations) {
        return this.readList((V)Arrays.asList(annotations));
    }

    public List<SecurityRequirement> readList(Collection<AnnotationInstance> annotations) {
        return annotations.stream().map(this::read).collect(Collectors.toList());
    }

    @Override
    public SecurityRequirement read(AnnotationInstance annotation) {
        Map.Entry<String, List<String>> scheme = this.readEntry(annotation);
        return new SecurityRequirementImpl().addScheme(scheme.getKey(), scheme.getValue());
    }

    Map.Entry<String, List<String>> readEntry(AnnotationInstance annotation) {
        String name = (String)this.value(annotation, PROP_NAME);
        String[] scopes = (String[])this.value(annotation, PROP_SCOPES);
        if (scopes != null) {
            return SecurityRequirementIO.entry(name, new ArrayList<String>(Arrays.asList(scopes)));
        }
        return SecurityRequirementIO.entry(name, null);
    }

    public List<SecurityRequirement> readList(V node) {
        return Optional.ofNullable(node).filter(this.jsonIO()::isArray).map(this.jsonIO()::asArray).map(this.jsonIO()::entries).map(Collection::stream).map(elements -> {
            IoLogging.logger.jsonArray("SecurityRequirement");
            return elements.filter(this.jsonIO()::isObject).map(this.jsonIO()::asObject).map(this::readObject).collect(Collectors.toCollection(ArrayList::new));
        }).orElse(null);
    }

    @Override
    public SecurityRequirement readObject(O node) {
        SecurityRequirementImpl requirement = new SecurityRequirementImpl();
        this.jsonIO().properties(node).forEach(field -> {
            String schemeName = (String)field.getKey();
            if (this.jsonIO().isArray(field.getValue())) {
                Object scopeArray = this.jsonIO().asArray(field.getValue());
                List scopes = this.jsonIO().entries(scopeArray).stream().map(this.jsonIO()::asString).collect(Collectors.toList());
                requirement.addScheme(schemeName, scopes);
            } else {
                requirement.addScheme(schemeName);
            }
        });
        return requirement;
    }

    @Override
    public Optional<A> write(List<SecurityRequirement> models) {
        return this.optionalJsonArray(models).map(array -> {
            for (SecurityRequirement model : models) {
                this.write(model).ifPresent(object -> this.jsonIO().add(array, object));
            }
            return array;
        }).map(this.jsonIO()::buildArray);
    }

    @Override
    public Optional<O> write(SecurityRequirement model) {
        return this.optionalJsonObject(model.getSchemes()).map(node -> {
            model.getSchemes().forEach((schemeName, scopes) -> this.jsonIO().set(node, (String)schemeName, this.jsonIO().toJson(scopes).orElseGet(() -> this.jsonIO().buildArray(this.jsonIO().createArray()))));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

