/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

public class LocalDateTime
extends AbstractExpression {
    private Identifier identifier;

    public LocalDateTime(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.identifier = Identifier.parse(wordParser);
        this.setText(this.identifier.name);
        wordParser.moveForward(this.identifier.name);
    }

    public void runByType(Runnable dateAction, Runnable timeAction, Runnable dateTimeAction) {
        switch (this.identifier != null ? this.identifier : Identifier.getIdentifier(this.getText())) {
            case DATE: {
                dateAction.run();
                return;
            }
            case TIME: {
                timeAction.run();
                return;
            }
            case DATETIME: {
                dateTimeAction.run();
                return;
            }
        }
        throw new IllegalStateException("Unknown value of " + this.getText() + " LocalDateTime expression");
    }

    public <R> R getValueByType(Supplier<R> dateAction, Supplier<R> timeAction, Supplier<R> dateTimeAction) {
        switch (this.identifier != null ? this.identifier : Identifier.getIdentifier(this.getText())) {
            case DATE: {
                return dateAction.get();
            }
            case TIME: {
                return timeAction.get();
            }
            case DATETIME: {
                return dateTimeAction.get();
            }
        }
        throw new IllegalStateException("Unknown value of " + this.getText() + " LocalDateTime expression");
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("local_datetime_type");
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier.name : this.getText());
    }

    @Override
    public String toActualText() {
        return this.getText();
    }

    private static enum Identifier {
        DATE("date"),
        DATETIME("datetime"),
        TIME("time");

        private final String name;

        private Identifier(String name) {
            this.name = name;
        }

        private static final Identifier getIdentifier(String name) {
            switch (name.toUpperCase()) {
                case "DATE": {
                    return DATE;
                }
                case "TIME": {
                    return TIME;
                }
                case "DATETIME": {
                    return DATETIME;
                }
            }
            return null;
        }

        private static Identifier parse(WordParser wordParser) {
            int position = wordParser.position();
            switch (wordParser.character(position)) {
                case 'D': 
                case 'd': {
                    switch (wordParser.character(position + 4)) {
                        case 'T': 
                        case 't': {
                            return DATETIME;
                        }
                    }
                    return DATE;
                }
            }
            return TIME;
        }
    }
}

