/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.ObservesAsync;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.EventContext;
import jakarta.enterprise.inject.spi.EventMetadata;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.WithAnnotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.event.EventContextImpl;
import org.apache.webbeans.event.OwbObserverMethod;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;

public class ObserverMethodImpl<T>
implements OwbObserverMethod<T> {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(ObserverMethodImpl.class);
    private final AbstractOwbBean<?> ownerBean;
    private final boolean ifExist;
    private final Set<Annotation> observedQualifiers;
    private final Type observedEventType;
    private final TransactionPhase phase;
    private final Set<InjectionPoint> injectionPoints;
    private final Method view;
    private AnnotatedMethod<T> annotatedObserverMethod;
    private AnnotatedParameter<T> annotatedObservesParameter;
    private int priority = 2500;
    private boolean isAsync;

    public ObserverMethodImpl(AbstractOwbBean<?> ownerBean, AnnotatedMethod<T> annotatedObserverMethod, AnnotatedParameter<T> annotatedObservesParameter) {
        this(ownerBean, annotatedObserverMethod, annotatedObservesParameter, true);
    }

    protected ObserverMethodImpl(AbstractOwbBean<?> ownerBean, AnnotatedMethod<T> annotatedObserverMethod, AnnotatedParameter<T> annotatedObservesParameter, boolean fireEvent) {
        OpenWebBeansEjbPlugin ejbPlugin;
        Class<Observes> observerAnnotation;
        this.ownerBean = ownerBean;
        this.annotatedObservesParameter = annotatedObservesParameter;
        this.annotatedObserverMethod = annotatedObserverMethod;
        this.observedEventType = annotatedObservesParameter.getBaseType();
        Observes observes = (Observes)annotatedObservesParameter.getAnnotation(Observes.class);
        if (observes != null) {
            this.ifExist = observes.notifyObserver() == Reception.IF_EXISTS;
            this.phase = observes.during();
            observerAnnotation = Observes.class;
        } else {
            ObservesAsync observesAsync = (ObservesAsync)annotatedObservesParameter.getAnnotation(ObservesAsync.class);
            this.ifExist = observesAsync.notifyObserver() == Reception.IF_EXISTS;
            this.phase = TransactionPhase.IN_PROGRESS;
            observerAnnotation = ObservesAsync.class;
            this.isAsync = true;
        }
        this.observedQualifiers = new HashSet<Annotation>();
        for (Annotation annotation : annotatedObservesParameter.getAnnotations()) {
            if (!ownerBean.getWebBeansContext().getAnnotationManager().isQualifierAnnotation(annotation.annotationType())) continue;
            this.observedQualifiers.add(annotation);
        }
        Priority priorityAnn = (Priority)annotatedObservesParameter.getAnnotation(Priority.class);
        if (priorityAnn != null) {
            this.priority = priorityAnn.value();
        }
        this.view = (ejbPlugin = this.getWebBeansContext().getPluginLoader().getEjbPlugin()) != null && ejbPlugin.isNewSessionBean(ownerBean.getBeanClass()) ? ejbPlugin.resolveViewMethod(ownerBean, annotatedObserverMethod.getJavaMember()) : annotatedObserverMethod.getJavaMember();
        this.injectionPoints = new LinkedHashSet<InjectionPoint>();
        for (AnnotatedParameter parameter : annotatedObserverMethod.getParameters()) {
            if (parameter.isAnnotationPresent(observerAnnotation)) continue;
            this.injectionPoints.add(this.getWebBeansContext().getInjectionPointFactory().buildInjectionPoint(ownerBean, parameter, fireEvent));
        }
        this.checkObserverCondition(annotatedObservesParameter);
        if (!this.view.isAccessible()) {
            ownerBean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)this.view, true);
        }
    }

    protected void checkObserverCondition(AnnotatedParameter<T> annotatedObservesParameter) {
        if (annotatedObservesParameter.getAnnotation(WithAnnotations.class) != null) {
            throw new WebBeansConfigurationException("@WithAnnotations must only be used for ProcessAnnotatedType events");
        }
    }

    @Override
    public AbstractOwbBean<?> getOwnerBean() {
        return this.ownerBean;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    public void notify(T event) {
        this.notify(new EventContextImpl<T>(event, null));
    }

    /*
     * Exception decompiling
     */
    public void notify(EventContext<T> eventContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void invoke(Object object, Object[] args) throws IllegalAccessException, InvocationTargetException {
        this.view.invoke(object, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ObserverParams> getMethodArguments(Object event, EventMetadata metadata) {
        if (this.injectionPoints.isEmpty() && this.annotatedObservesParameter.getPosition() == 0) {
            return null;
        }
        ArrayList<ObserverParams> list = new ArrayList<ObserverParams>();
        if (this.annotatedObservesParameter.getPosition() == 0) {
            ObserverParams param = new ObserverParams();
            param.instance = event;
            list.add(param);
        }
        WebBeansContext webBeansContext = this.ownerBean.getWebBeansContext();
        BeanManagerImpl manager = webBeansContext.getBeanManagerImpl();
        for (InjectionPoint injectionPoint : this.injectionPoints) {
            ObserverParams param = new ObserverParams();
            param.isBean = true;
            if (injectionPoint.getType() == BeanManager.class && injectionPoint.getQualifiers().contains((Object)DefaultLiteral.INSTANCE)) {
                param.instance = webBeansContext.getInjectableBeanManager();
                param.isBean = false;
            } else {
                Object instance;
                Bean<?> injectedBean = manager.getInjectionResolver().getInjectionPointBean(injectionPoint);
                CreationalContext creational = manager.createCreationalContext((Contextual)injectedBean);
                creational.putInjectionPoint(metadata.getInjectionPoint());
                creational.putInjectionPoint(injectionPoint);
                creational.putEventMetadata(metadata);
                try {
                    instance = manager.getReference(injectedBean, null, creational);
                }
                finally {
                    creational.removeEventMetadata();
                    creational.removeInjectionPoint();
                    creational.removeInjectionPoint();
                }
                param.creational = creational;
                param.instance = instance;
                param.bean = injectedBean;
            }
            list.add(param);
            if (list.size() != this.annotatedObservesParameter.getPosition()) continue;
            param = new ObserverParams();
            param.instance = event;
            list.add(param);
        }
        return list;
    }

    public Class<?> getBeanClass() {
        return this.ownerBean.getBeanClass();
    }

    public Set<Annotation> getObservedQualifiers() {
        return this.observedQualifiers;
    }

    public Type getObservedType() {
        return this.observedEventType;
    }

    public Reception getReception() {
        return this.ifExist ? Reception.IF_EXISTS : Reception.ALWAYS;
    }

    public TransactionPhase getTransactionPhase() {
        return this.phase;
    }

    public AnnotatedMethod<T> getObserverMethod() {
        return this.annotatedObserverMethod;
    }

    protected WebBeansContext getWebBeansContext() {
        return this.ownerBean.getWebBeansContext();
    }

    public void setObserverMethod(AnnotatedMethod<T> m) {
        this.annotatedObserverMethod = m;
    }

    private static class ObserverParams {
        private Bean<Object> bean;
        private Object instance;
        private CreationalContext<Object> creational;
        private boolean isBean;

        private ObserverParams() {
        }
    }
}

