/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.documentation;

import java.io.Reader;
import java.io.StringReader;
import org.apache.uima.ruta.ide.ui.documentation.ScriptDocumentationProvider;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class RutaCommentDocumentationProvider
extends ScriptDocumentationProvider
implements IScriptDocumentationProvider {
    @Override
    protected String getLine(Document d, int line) throws BadLocationException {
        return d.get(d.getLineOffset(line), d.getLineLength(line));
    }

    protected String getHeaderComment(IMember member) {
        if (member instanceof IField) {
            return null;
        }
        try {
            ISourceRange range = member.getSourceRange();
            if (range == null) {
                return null;
            }
            IBuffer buf = null;
            ISourceModule compilationUnit = member.getSourceModule();
            if (!compilationUnit.isConsistent()) {
                return null;
            }
            buf = compilationUnit.getBuffer();
            int start = range.getOffset();
            String contents = buf.getContents();
            Object result = "";
            Document doc = new Document(contents);
            try {
                String curLine;
                String curLineTrimmed;
                int line = doc.getLineOfOffset(start);
                if (--line < 0) {
                    return null;
                }
                boolean emptyEnd = true;
                while (line >= 0 && ((curLineTrimmed = (curLine = this.getLine(doc, line)).trim()).length() == 0 && emptyEnd || curLineTrimmed.startsWith("#"))) {
                    if (curLineTrimmed.length() != 0) {
                        emptyEnd = false;
                    }
                    result = curLine + (String)result;
                    --line;
                }
            }
            catch (BadLocationException e) {
                return null;
            }
            return result;
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    public Reader getInfo(IMember member, boolean lookIntoParents, boolean lookIntoExternal) {
        String header = this.getHeaderComment(member);
        return new StringReader(this.convertToHTML(header));
    }

    @Override
    protected String convertToHTML(String header) {
        StringBuffer result = new StringBuffer();
        Document d = new Document(header);
        int line = 0;
        while (true) {
            try {
                String str = this.getLine(d, line).trim();
                if (str == null) break;
                while (str.length() > 0 && str.startsWith("#")) {
                    str = str.substring(1);
                }
                while (str.length() > 0 && str.endsWith("#")) {
                    str = str.substring(0, str.length() - 1);
                }
                if (str.length() == 0) {
                    result.append("<p>");
                } else if (str.trim().matches("\\w*:")) {
                    result.append("<h4>");
                    result.append(str);
                    result.append("</h4>");
                } else {
                    result.append(str + "<br>");
                }
            }
            catch (BadLocationException e) {
                break;
            }
            ++line;
        }
        return result.toString();
    }

    public Reader getInfo(String content) {
        return null;
    }
}

