/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;

public class RutaStatement
extends Statement {
    private List<Expression> expressions;

    public RutaStatement(List<Expression> expressions) {
        this.setExpressions(expressions);
    }

    public RutaStatement(int start, int end, List<Expression> expressions) {
        super(start, end);
        if (expressions == null) {
            this.expressions = new ArrayList<Expression>();
        } else {
            this.setExpressions(expressions);
        }
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public Expression getAt(int index) {
        if (index >= 0 && index < this.expressions.size()) {
            return this.expressions.get(index);
        }
        return null;
    }

    public int getCount() {
        return this.expressions.size();
    }

    public int getKind() {
        return 2008;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Statement)this)) {
            if (this.expressions != null) {
                for (int i = 0; i < this.expressions.size(); ++i) {
                    ASTNode node = (ASTNode)this.expressions.get(i);
                    if (node == null) continue;
                    node.traverse(visitor);
                }
            }
            visitor.endvisit((Statement)this);
        }
    }

    public void printNode(CorePrinter output) {
        if (this.expressions != null) {
            output.formatPrintLn("");
            for (ASTNode aSTNode : this.expressions) {
                aSTNode.printNode(output);
                output.formatPrintLn(" ");
            }
        }
    }

    public String toString() {
        Object value = "";
        if (this.expressions != null) {
            for (ASTNode aSTNode : this.expressions) {
                value = (String)value + aSTNode.toString();
                value = (String)value + " ";
            }
        }
        return value;
    }

    public void setExpressions(List<Expression> asList) {
        this.expressions = asList;
        this.updateBoundaries();
    }

    private void updateBoundaries() {
        if (this.expressions != null && !this.expressions.isEmpty()) {
            Expression last;
            Expression first = this.expressions.get(0);
            if (first != null) {
                this.setStart(first.sourceStart());
            }
            if ((last = this.expressions.get(this.expressions.size() - 1)) != null) {
                this.setEnd(last.sourceEnd());
            }
        }
    }
}

