/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.ruta.ide.parser.ast.RutaBasicAnnotationType;
import org.apache.uima.ruta.ide.parser.ast.RutaImportStatement;
import org.apache.uima.ruta.ide.parser.ast.RutaPackageDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaTypeDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaVariableDeclaration;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.PositionInformation;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestVisitor;

public class RutaSourceElementRequestVisitor
extends SourceElementRequestVisitor {
    private static String ANONYMOUS_LAMBDA_FORM_MARKER = "<anonymous>";
    private List fNotAddedFields = new ArrayList();
    private String lastLambdaFormName = ANONYMOUS_LAMBDA_FORM_MARKER;
    private Map fTypeVariables = new HashMap();

    public RutaSourceElementRequestVisitor(ISourceElementRequestor requestor) {
        super((IElementRequestor)requestor);
    }

    protected String makeLanguageDependentValue(Expression value) {
        String outValue = "";
        return outValue;
    }

    protected void onEndVisitMethod(MethodDeclaration method) {
        TypeField typeField;
        if (this.fNotAddedFields.size() >= 1 && null != (typeField = (TypeField)this.fNotAddedFields.get(0)) && typeField.getDeclaredIn().equals(method)) {
            for (TypeField field : this.fNotAddedFields) {
                if (!this.canAddVariables(field.getToNode(), field.getName())) continue;
                PositionInformation pos = field.getPos();
                IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
                info.modifiers = 128;
                info.name = field.getName();
                info.nameSourceEnd = pos.nameEnd - 2;
                info.nameSourceStart = pos.nameStart;
                info.declarationStart = pos.sourceStart;
                this.fRequestor.enterField(info);
                this.fRequestor.exitField(pos.sourceEnd);
            }
            this.fNotAddedFields.clear();
        }
    }

    public boolean visit(Statement statement) throws Exception {
        super.visit(statement);
        if (statement instanceof RutaPackageDeclaration) {
            this.processPackage(statement);
            this.fNodes.pop();
            return false;
        }
        if (statement instanceof FieldDeclaration) {
            FieldDeclaration fieldDecl = (FieldDeclaration)statement;
            this.processFieldDeclaration(fieldDecl.getRef(), (Statement)fieldDecl);
            this.fNodes.pop();
            return false;
        }
        if (statement instanceof RutaImportStatement) {
            RutaImportStatement tmImport = (RutaImportStatement)statement;
            this.fNodes.pop();
            return false;
        }
        return true;
    }

    public boolean visit(Expression expression) throws Exception {
        if (expression instanceof VariableReference) {
            VariableReference varRef = (VariableReference)expression;
            this.fRequestor.acceptFieldReference(varRef.getName(), varRef.sourceStart());
        }
        return super.visit(expression);
    }

    private void processPackage(Statement statement) {
        RutaPackageDeclaration pack = (RutaPackageDeclaration)statement;
        this.fRequestor.acceptPackage(pack.getNameStart(), pack.getNameEnd(), pack.getName());
    }

    private void processFieldDeclaration(SimpleReference variableIDRef, Statement fullDeclaration) {
        int modifier = 0;
        if (fullDeclaration instanceof RutaVariableDeclaration) {
            modifier = 16;
            modifier |= ((RutaVariableDeclaration)fullDeclaration).getKind();
        } else if (fullDeclaration instanceof RutaBasicAnnotationType) {
            modifier = 2;
            modifier |= 0x800000;
        } else if (fullDeclaration instanceof RutaTypeDeclaration) {
            modifier = 64;
            modifier |= 0x800000;
        }
        if (this.canAddVariables((ASTNode)this.fNodes.peek(), variableIDRef.getName())) {
            IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
            info.modifiers = modifier;
            info.name = variableIDRef.getName();
            info.nameSourceEnd = variableIDRef.sourceEnd() - 1;
            info.nameSourceStart = variableIDRef.sourceStart();
            info.declarationStart = variableIDRef.sourceStart();
            this.fRequestor.enterField(info);
            if (fullDeclaration != null) {
                this.fRequestor.exitField(fullDeclaration.sourceEnd());
            } else {
                this.fRequestor.exitField(variableIDRef.sourceEnd());
            }
        }
    }

    private boolean canAddVariables(ASTNode type, String name) {
        if (this.fTypeVariables.containsKey(type)) {
            List variables = (List)this.fTypeVariables.get(type);
            if (variables.contains(name)) {
                return false;
            }
            variables.add(name);
            return true;
        }
        ArrayList<String> variables = new ArrayList<String>();
        variables.add(name);
        this.fTypeVariables.put(type, variables);
        return true;
    }

    public boolean endvisit(Statement s) throws Exception {
        return true;
    }

    public boolean visit(MethodDeclaration method) throws Exception {
        this.fNodes.push(method);
        List args = method.getArguments();
        String[] parameter = new String[args.size()];
        for (int a = 0; a < args.size(); ++a) {
            Argument arg = (Argument)args.get(a);
            parameter[a] = arg.getName();
        }
        IElementRequestor.MethodInfo mi = new IElementRequestor.MethodInfo();
        mi.parameterNames = parameter;
        mi.name = method.getName();
        mi.modifiers = method.getModifiers();
        mi.nameSourceStart = method.getNameStart();
        mi.nameSourceEnd = method.getNameEnd() - 1;
        mi.declarationStart = method.sourceStart();
        this.fInMethod = true;
        this.fCurrentMethod = method;
        this.fRequestor.enterMethod(mi);
        return true;
    }

    public boolean visit(ModuleDeclaration declaration) throws Exception {
        return super.visit(declaration);
    }

    private static class TypeField {
        private String fName;
        private String fInitValue;
        private PositionInformation fPos;
        private Expression fExpression;
        private ASTNode fToNode;
        private ASTNode declaredIn;

        TypeField(String name, String initValue, PositionInformation pos, Expression expression, ASTNode toNode, ASTNode declaredIn) {
            this.fName = name;
            this.fInitValue = initValue;
            this.fPos = pos;
            this.fExpression = expression;
            this.fToNode = toNode;
            this.declaredIn = declaredIn;
        }

        String getName() {
            return this.fName;
        }

        String getInitValue() {
            return this.fInitValue;
        }

        PositionInformation getPos() {
            return this.fPos;
        }

        Expression getExpression() {
            return this.fExpression;
        }

        ASTNode getToNode() {
            return this.fToNode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeField) {
                TypeField second = (TypeField)obj;
                return second.fName.equals(this.fName) && second.fToNode.equals(this.fToNode);
            }
            return super.equals(obj);
        }

        public String toString() {
            return this.fName;
        }

        public ASTNode getDeclaredIn() {
            return this.declaredIn;
        }
    }
}

