/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.constraint;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.uima.cas.FSTypeConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.ruta.type.RutaBasic;

public class BasicTypeConstraint
implements FSTypeConstraint {
    private static final long serialVersionUID = 1115953538613617791L;
    private final Collection<Type> types;
    private final boolean matchOnEmpty;

    public BasicTypeConstraint(Collection<Type> types, boolean matchOnEmpty) {
        this.types = types;
        this.matchOnEmpty = matchOnEmpty;
    }

    public BasicTypeConstraint(Type type, boolean matchOnEmpty) {
        if (type != null) {
            this.types = new ArrayList<Type>();
            this.types.add(type);
        } else {
            this.types = null;
        }
        this.matchOnEmpty = matchOnEmpty;
    }

    public void add(Type type) {
        this.types.add(type);
    }

    public void add(String typeString) {
        throw new NotImplementedException("Not supported.");
    }

    public boolean match(FeatureStructure fs) {
        boolean result = false;
        if (fs instanceof RutaBasic) {
            RutaBasic tmb = (RutaBasic)fs;
            if (tmb.isEmpty()) {
                return this.matchOnEmpty;
            }
            if (this.types != null) {
                for (Type each : this.types) {
                    if (!(result |= tmb.isPartOf(each))) continue;
                    return true;
                }
            }
        }
        return result;
    }

    public String toString() {
        return "(BASIC  with " + String.valueOf(this.types) + ")";
    }
}

