/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.bool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.bool.AbstractBooleanListExpression;
import org.apache.uima.ruta.expression.feature.FeatureExpression;
import org.apache.uima.ruta.expression.feature.LazyFeature;
import org.apache.uima.ruta.rule.MatchContext;

public class BooleanListFeatureExpression
extends AbstractBooleanListExpression {
    private FeatureExpression fe;

    public BooleanListFeatureExpression(FeatureExpression fe) {
        this.fe = fe;
    }

    @Override
    public List<Boolean> getList(MatchContext context, RutaStream stream) {
        AnnotationFS annotation = context.getAnnotation();
        Feature feature = this.fe.getFeature(context, stream);
        if (feature == null || !feature.getRange().isArray() || !StringUtils.equals((CharSequence)feature.getRange().getName(), (CharSequence)"uima.cas.BooleanArray")) {
            return Collections.emptyList();
        }
        List<AnnotationFS> list = this.getTargetAnnotation(annotation, this.fe, context, stream);
        Collection<? extends FeatureStructure> featureStructures = this.fe.getFeatureStructures(list, false, context, stream);
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (FeatureStructure featureStructure : featureStructures) {
            FeatureStructure featureValue;
            if (feature instanceof LazyFeature) {
                LazyFeature lazyFeature = (LazyFeature)feature;
                feature = lazyFeature.initialize(featureStructure);
            }
            if (!((featureValue = featureStructure.getFeatureValue(feature)) instanceof BooleanArrayFS)) continue;
            BooleanArrayFS array = (BooleanArrayFS)featureValue;
            for (int i = 0; i < array.size(); ++i) {
                Boolean b = array.get(i);
                result.add(b);
            }
        }
        return result;
    }

    public FeatureExpression getFeatureExpression() {
        return this.fe;
    }

    public void setFeatureExpression(FeatureExpression fe) {
        this.fe = fe;
    }
}

