/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.ir.ConstantPool;
import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerHelpers;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;

public class ConstantPoolPrinter
implements ConstantPool.Visitor {
    private static final int MAX_TAG_LENGTH;
    private final ITextOutput _output;
    private final DecompilerSettings _settings;
    private boolean _isHeaderPrinted;

    public ConstantPoolPrinter(ITextOutput output) {
        this(output, DecompilerSettings.javaDefaults());
    }

    public ConstantPoolPrinter(ITextOutput output, DecompilerSettings settings) {
        this._output = (ITextOutput)VerifyArgument.notNull((Object)output, (String)"output");
        this._settings = (DecompilerSettings)VerifyArgument.notNull((Object)settings, (String)"settings");
    }

    protected void printTag(ConstantPool.Tag tag) {
        this._output.writeAttribute(String.format("%1$-" + MAX_TAG_LENGTH + "s  ", new Object[]{tag}));
    }

    @Override
    public void visit(ConstantPool.Entry entry) {
        VerifyArgument.notNull((Object)entry, (String)"entry");
        if (!this._isHeaderPrinted) {
            this._output.writeAttribute("Constant Pool");
            this._output.write(':');
            this._output.writeLine();
            this._isHeaderPrinted = true;
        }
        this._output.indent();
        this._output.writeLiteral(String.format("%1$5d", entry.index));
        this._output.write(": ");
        this.printTag(entry.getTag());
        entry.accept(this);
        this._output.writeLine();
        this._output.unindent();
    }

    @Override
    public void visitTypeInfo(ConstantPool.TypeInfoEntry info) {
        this._output.writeDelimiter("#");
        this._output.writeLiteral(String.format("%1$-14d", info.nameIndex));
        this._output.writeComment(String.format("//  %1$s", StringUtilities.escape((String)info.getName(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled())));
    }

    @Override
    public void visitDoubleConstant(ConstantPool.DoubleConstantEntry info) {
        DecompilerHelpers.writePrimitiveValue(this._output, info.getConstantValue());
    }

    @Override
    public void visitFieldReference(ConstantPool.FieldReferenceEntry info) {
        ConstantPool.NameAndTypeDescriptorEntry nameAndTypeInfo = info.getNameAndTypeInfo();
        int startColumn = this._output.getColumn();
        this._output.writeDelimiter("#");
        this._output.writeLiteral(info.typeInfoIndex);
        this._output.writeDelimiter(".");
        this._output.writeDelimiter("#");
        this._output.writeLiteral(info.nameAndTypeDescriptorIndex);
        int endColumn = this._output.getColumn();
        int padding = 14 - (endColumn - startColumn);
        String paddingText = padding > 0 ? StringUtilities.repeat((char)' ', (int)padding) : "";
        this._output.writeComment(String.format(paddingText + " //  %1$s.%2$s:%3$s", StringUtilities.escape((String)info.getClassName(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled()), StringUtilities.escape((String)nameAndTypeInfo.getName(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled()), StringUtilities.escape((String)nameAndTypeInfo.getType(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled())));
    }

    @Override
    public void visitFloatConstant(ConstantPool.FloatConstantEntry info) {
        DecompilerHelpers.writePrimitiveValue(this._output, info.getConstantValue());
    }

    @Override
    public void visitIntegerConstant(ConstantPool.IntegerConstantEntry info) {
        DecompilerHelpers.writePrimitiveValue(this._output, info.getConstantValue());
    }

    @Override
    public void visitInterfaceMethodReference(ConstantPool.InterfaceMethodReferenceEntry info) {
        ConstantPool.NameAndTypeDescriptorEntry nameAndTypeInfo = info.getNameAndTypeInfo();
        int startColumn = this._output.getColumn();
        this._output.writeDelimiter("#");
        this._output.writeLiteral(info.typeInfoIndex);
        this._output.writeDelimiter(".");
        this._output.writeDelimiter("#");
        this._output.writeLiteral(info.nameAndTypeDescriptorIndex);
        int endColumn = this._output.getColumn();
        int padding = 14 - (endColumn - startColumn);
        String paddingText = padding > 0 ? StringUtilities.repeat((char)' ', (int)padding) : "";
        this._output.writeComment(String.format(paddingText + " //  %1$s.%2$s:%3$s", StringUtilities.escape((String)info.getClassName(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled()), StringUtilities.escape((String)nameAndTypeInfo.getName(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled()), StringUtilities.escape((String)nameAndTypeInfo.getType(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled())));
    }

    @Override
    public void visitInvokeDynamicInfo(ConstantPool.InvokeDynamicInfoEntry info) {
        ConstantPool.NameAndTypeDescriptorEntry nameAndTypeInfo = info.getNameAndTypeDescriptor();
        int startColumn = this._output.getColumn();
        this._output.writeLiteral(info.bootstrapMethodAttributeIndex);
        this._output.writeDelimiter(", ");
        this._output.writeDelimiter("#");
        this._output.writeLiteral(nameAndTypeInfo.nameIndex);
        this._output.writeDelimiter(".");
        this._output.writeDelimiter("#");
        this._output.writeLiteral(nameAndTypeInfo.typeDescriptorIndex);
        int endColumn = this._output.getColumn();
        int padding = 14 - (endColumn - startColumn);
        String paddingText = padding > 0 ? StringUtilities.repeat((char)' ', (int)padding) : "";
        this._output.writeComment(String.format(paddingText + " //  %1$s:%2$s", StringUtilities.escape((String)nameAndTypeInfo.getName(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled()), StringUtilities.escape((String)nameAndTypeInfo.getType(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled())));
    }

    @Override
    public void visitLongConstant(ConstantPool.LongConstantEntry info) {
        DecompilerHelpers.writePrimitiveValue(this._output, info.getConstantValue());
    }

    @Override
    public void visitNameAndTypeDescriptor(ConstantPool.NameAndTypeDescriptorEntry info) {
        int startColumn = this._output.getColumn();
        this._output.writeDelimiter("#");
        this._output.writeLiteral(info.nameIndex);
        this._output.writeDelimiter(".");
        this._output.writeDelimiter("#");
        this._output.writeLiteral(info.typeDescriptorIndex);
        int endColumn = this._output.getColumn();
        int padding = 14 - (endColumn - startColumn);
        String paddingText = padding > 0 ? StringUtilities.repeat((char)' ', (int)padding) : "";
        this._output.writeComment(String.format(paddingText + " //  %1$s:%2$s", StringUtilities.escape((String)info.getName(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled()), StringUtilities.escape((String)info.getType(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled())));
    }

    @Override
    public void visitMethodReference(ConstantPool.MethodReferenceEntry info) {
        ConstantPool.NameAndTypeDescriptorEntry nameAndTypeInfo = info.getNameAndTypeInfo();
        int startColumn = this._output.getColumn();
        this._output.writeDelimiter("#");
        this._output.writeLiteral(info.typeInfoIndex);
        this._output.writeDelimiter(".");
        this._output.writeDelimiter("#");
        this._output.writeLiteral(info.nameAndTypeDescriptorIndex);
        int endColumn = this._output.getColumn();
        int padding = 14 - (endColumn - startColumn);
        String paddingText = padding > 0 ? StringUtilities.repeat((char)' ', (int)padding) : "";
        this._output.writeComment(String.format(paddingText + " //  %1$s.%2$s:%3$s", StringUtilities.escape((String)info.getClassName(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled()), StringUtilities.escape((String)nameAndTypeInfo.getName(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled()), StringUtilities.escape((String)nameAndTypeInfo.getType(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled())));
    }

    @Override
    public void visitMethodHandle(ConstantPool.MethodHandleEntry info) {
        ConstantPool.ReferenceEntry reference = info.getReference();
        ConstantPool.NameAndTypeDescriptorEntry nameAndTypeInfo = reference.getNameAndTypeInfo();
        int startColumn = this._output.getColumn();
        this._output.writeLiteral((Object)info.referenceKind);
        this._output.write(' ');
        this._output.writeDelimiter("#");
        this._output.writeLiteral(reference.typeInfoIndex);
        this._output.writeDelimiter(".");
        this._output.writeDelimiter("#");
        this._output.writeLiteral(reference.nameAndTypeDescriptorIndex);
        int endColumn = this._output.getColumn();
        int padding = 28 - (endColumn - startColumn);
        String paddingText = padding > 0 ? StringUtilities.repeat((char)' ', (int)padding) : "";
        this._output.writeComment(String.format(paddingText + " //  %1$s.%2$s:%3$s", StringUtilities.escape((String)reference.getClassName(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled()), StringUtilities.escape((String)nameAndTypeInfo.getName(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled()), StringUtilities.escape((String)nameAndTypeInfo.getType(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled())));
    }

    @Override
    public void visitMethodType(ConstantPool.MethodTypeEntry info) {
        IMethodSignature signature;
        String text = info.getType();
        try {
            signature = MetadataParser.unbound().parseMethodSignature(text);
        }
        catch (Throwable ignored) {
            signature = null;
        }
        this._output.writeReference(text, signature);
    }

    @Override
    public void visitStringConstant(ConstantPool.StringConstantEntry info) {
        this._output.writeDelimiter("#");
        this._output.writeLiteral(String.format("%1$-14d", info.stringIndex));
        this._output.writeComment(String.format("//  %1$s", StringUtilities.escape((String)info.getValue(), (boolean)true, (boolean)this._settings.isUnicodeOutputEnabled())));
    }

    @Override
    public void visitUtf8StringConstant(ConstantPool.Utf8StringConstantEntry info) {
        DecompilerHelpers.writePrimitiveValue(this._output, info.getConstantValue());
    }

    @Override
    public void visitEnd() {
    }

    static {
        int maxTagLength = 0;
        for (ConstantPool.Tag tag : ConstantPool.Tag.values()) {
            int length = tag.name().length();
            if (length <= maxTagLength) continue;
            maxTagLength = length;
        }
        MAX_TAG_LENGTH = maxTagLength;
    }
}

