/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class ReturnStatement
extends Statement {
    public static final TokenRole RETURN_KEYWORD_ROLE = new TokenRole("return", 1);

    public ReturnStatement(int offset) {
        super(offset);
    }

    public ReturnStatement(int offset, Expression returnValue) {
        super(offset);
        this.setExpression(returnValue);
    }

    public final JavaTokenNode getReturnToken() {
        return this.getChildByRole(RETURN_KEYWORD_ROLE);
    }

    public final Expression getExpression() {
        return this.getChildByRole(Roles.EXPRESSION);
    }

    public final void setExpression(Expression value) {
        this.setChildByRole(Roles.EXPRESSION, value);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitReturnStatement(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof ReturnStatement && !other.isNull() && this.getExpression().matches(((ReturnStatement)other).getExpression(), match);
    }
}

