/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public final class SuperReferenceExpression
extends Expression {
    private static final String SUPER_TEXT = "super";
    private TextLocation _startLocation;
    private TextLocation _endLocation;

    public SuperReferenceExpression(int offset) {
        this(offset, TextLocation.EMPTY);
    }

    public SuperReferenceExpression(int offset, TextLocation startLocation) {
        super(offset);
        this._startLocation = (TextLocation)VerifyArgument.notNull((Object)startLocation, (String)"startLocation");
        this._endLocation = new TextLocation(startLocation.line(), startLocation.column() + SUPER_TEXT.length());
    }

    @Override
    public TextLocation getStartLocation() {
        return this._startLocation;
    }

    @Override
    public TextLocation getEndLocation() {
        return this._endLocation;
    }

    public final Expression getTarget() {
        return this.getChildByRole(Roles.TARGET_EXPRESSION);
    }

    public final void setTarget(Expression value) {
        this.setChildByRole(Roles.TARGET_EXPRESSION, value);
    }

    public void setStartLocation(TextLocation startLocation) {
        this._startLocation = (TextLocation)VerifyArgument.notNull((Object)startLocation, (String)"startLocation");
        this._endLocation = new TextLocation(startLocation.line(), startLocation.column() + SUPER_TEXT.length());
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitSuperReferenceExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof SuperReferenceExpression && this.getTarget().matches(((SuperReferenceExpression)other).getTarget(), match);
    }
}

