/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class SynchronizedStatement
extends Statement {
    public static final TokenRole SYNCHRONIZED_KEYWORD_ROLE = new TokenRole("synchronized", 1);

    public SynchronizedStatement(int offset) {
        super(offset);
    }

    public final Statement getEmbeddedStatement() {
        return this.getChildByRole(Roles.EMBEDDED_STATEMENT);
    }

    public final void setEmbeddedStatement(Statement value) {
        this.setChildByRole(Roles.EMBEDDED_STATEMENT, value);
    }

    public final Expression getExpression() {
        return this.getChildByRole(Roles.EXPRESSION);
    }

    public final void setExpression(Expression value) {
        this.setChildByRole(Roles.EXPRESSION, value);
    }

    public final JavaTokenNode getSynchronizedToken() {
        return this.getChildByRole(SYNCHRONIZED_KEYWORD_ROLE);
    }

    public final JavaTokenNode getLeftParenthesisToken() {
        return this.getChildByRole(Roles.LEFT_PARENTHESIS);
    }

    public final JavaTokenNode getRightParenthesisToken() {
        return this.getChildByRole(Roles.RIGHT_PARENTHESIS);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitSynchronizedStatement(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof SynchronizedStatement) {
            SynchronizedStatement otherStatement = (SynchronizedStatement)other;
            return !otherStatement.isNull() && this.getExpression().matches(otherStatement.getExpression(), match) && this.getEmbeddedStatement().matches(otherStatement.getEmbeddedStatement(), match);
        }
        return false;
    }
}

