/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Predicate;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.SuperReferenceExpression;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.NamedNode;

public class RemoveHiddenMembersTransform
extends ContextTrackingVisitor<Void> {
    private static final INode DEFAULT_CONSTRUCTOR_BODY = new BlockStatement(new ExpressionStatement(new InvocationExpression(-34, (Expression)new SuperReferenceExpression(-34), new Expression[0])));
    private static final AstNode EMPTY_SUPER = new ExpressionStatement(new NamedNode("target", new SuperReferenceExpression(-34).invoke(new Expression[0])).toExpression());

    public RemoveHiddenMembersTransform(DecompilerContext context) {
        super(context);
    }

    @Override
    public Void visitTypeDeclaration(TypeDeclaration node, Void p) {
        TypeDefinition type;
        if (!(node.getParent() instanceof CompilationUnit) && (type = node.getUserData(Keys.TYPE_DEFINITION)) != null && AstBuilder.isMemberHidden(type, this.context)) {
            node.remove();
            return null;
        }
        return (Void)super.visitTypeDeclaration(node, p);
    }

    @Override
    public Void visitFieldDeclaration(FieldDeclaration node, Void data) {
        FieldDefinition field = node.getUserData(Keys.FIELD_DEFINITION);
        if (field != null && AstBuilder.isMemberHidden(field, this.context)) {
            node.remove();
            return null;
        }
        return (Void)super.visitFieldDeclaration(node, data);
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration node, Void p) {
        MethodDefinition method = node.getUserData(Keys.METHOD_DEFINITION);
        if (method != null) {
            if (AstBuilder.isMemberHidden(method, this.context)) {
                node.remove();
                return null;
            }
            if (method.isTypeInitializer() && node.getBody().getStatements().isEmpty()) {
                node.remove();
                return null;
            }
        }
        return (Void)super.visitMethodDeclaration(node, p);
    }

    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration node, Void p) {
        final MethodDefinition method = node.getUserData(Keys.METHOD_DEFINITION);
        if (method != null) {
            boolean hasOtherConstructors;
            TypeDefinition declaringType;
            if (AstBuilder.isMemberHidden(method, this.context)) {
                if (method.getDeclaringType().isEnum() && method.getDeclaringType().isAnonymous() && !node.getBody().getStatements().isEmpty()) {
                    return (Void)super.visitConstructorDeclaration(node, p);
                }
                node.remove();
                return null;
            }
            if (!this.context.getSettings().getShowSyntheticMembers() && node.getParameters().isEmpty() && DEFAULT_CONSTRUCTOR_BODY.matches(node.getBody()) && (declaringType = method.getDeclaringType()) != null && !(hasOtherConstructors = CollectionUtilities.any(declaringType.getDeclaredMethods(), (Predicate)new Predicate<MethodDefinition>(){

                public boolean test(MethodDefinition m) {
                    return m.isConstructor() && !m.isSynthetic() && !StringUtilities.equals((String)m.getErasedSignature(), (String)method.getErasedSignature());
                }
            }))) {
                node.remove();
                return null;
            }
        }
        return (Void)super.visitConstructorDeclaration(node, p);
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatement node, Void data) {
        AstNode target;
        MemberReference member;
        Match match;
        super.visitExpressionStatement(node, data);
        if (this.inConstructor() && !this.context.getSettings().getShowSyntheticMembers() && (match = EMPTY_SUPER.match(node)).success() && (member = (target = (AstNode)CollectionUtilities.firstOrDefault(match.get("target"))).getUserData(Keys.MEMBER_REFERENCE)) instanceof MethodReference && ((MethodReference)member).isConstructor()) {
            node.remove();
        }
        return null;
    }
}

