/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.core.Predicate;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.transforms.AddReferenceQualifiersTransform;
import com.strobel.decompiler.languages.java.ast.transforms.AssertStatementTransform;
import com.strobel.decompiler.languages.java.ast.transforms.BreakTargetRelocation;
import com.strobel.decompiler.languages.java.ast.transforms.CollapseImportsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.ConvertLoopsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.DeclareLocalClassesTransform;
import com.strobel.decompiler.languages.java.ast.transforms.DeclareVariablesTransform;
import com.strobel.decompiler.languages.java.ast.transforms.EclipseEnumSwitchRewriterTransform;
import com.strobel.decompiler.languages.java.ast.transforms.EclipseStringSwitchRewriterTransform;
import com.strobel.decompiler.languages.java.ast.transforms.EliminateSyntheticAccessorsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.EnumRewriterTransform;
import com.strobel.decompiler.languages.java.ast.transforms.EnumSwitchRewriterTransform;
import com.strobel.decompiler.languages.java.ast.transforms.FlattenElseIfStatementsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.FlattenSwitchBlocksTransform;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;
import com.strobel.decompiler.languages.java.ast.transforms.InlineEscapingAssignmentsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.InsertConstantReferencesTransform;
import com.strobel.decompiler.languages.java.ast.transforms.InsertNecessaryConversionsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.InsertOverrideAnnotationsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.IntroduceInitializersTransform;
import com.strobel.decompiler.languages.java.ast.transforms.IntroduceOuterClassReferencesTransform;
import com.strobel.decompiler.languages.java.ast.transforms.IntroduceStringConcatenationTransform;
import com.strobel.decompiler.languages.java.ast.transforms.LabelCleanupTransform;
import com.strobel.decompiler.languages.java.ast.transforms.LambdaTransform;
import com.strobel.decompiler.languages.java.ast.transforms.MarkReferencedSyntheticsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.RemoveHiddenMembersTransform;
import com.strobel.decompiler.languages.java.ast.transforms.RemoveImplicitBoxingTransform;
import com.strobel.decompiler.languages.java.ast.transforms.RemoveRedundantCastsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.RemoveRedundantInitializersTransform;
import com.strobel.decompiler.languages.java.ast.transforms.RewriteInnerClassConstructorCalls;
import com.strobel.decompiler.languages.java.ast.transforms.RewriteLocalClassesTransform;
import com.strobel.decompiler.languages.java.ast.transforms.RewriteNewArrayLambdas;
import com.strobel.decompiler.languages.java.ast.transforms.SimplifyArithmeticExpressionsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.SimplifyAssignmentsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.StringSwitchRewriterTransform;
import com.strobel.decompiler.languages.java.ast.transforms.TryWithResourcesTransform;
import com.strobel.decompiler.languages.java.ast.transforms.VarArgsTransform;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TransformationPipeline {
    private static final Logger LOG = Logger.getLogger(TransformationPipeline.class.getSimpleName());

    public static IAstTransform[] createPipeline(DecompilerContext context) {
        return new IAstTransform[]{new EnumRewriterTransform(context), new EnumSwitchRewriterTransform(context), new EclipseEnumSwitchRewriterTransform(context), new AssertStatementTransform(context), new RemoveImplicitBoxingTransform(context), new RemoveRedundantCastsTransform(context), new ConvertLoopsTransform(context), new BreakTargetRelocation(context), new LabelCleanupTransform(context), new TryWithResourcesTransform(context), new DeclareVariablesTransform(context), new StringSwitchRewriterTransform(context), new EclipseStringSwitchRewriterTransform(context), new SimplifyAssignmentsTransform(context), new EliminateSyntheticAccessorsTransform(context), new LambdaTransform(context), new RewriteNewArrayLambdas(context), new RewriteLocalClassesTransform(context), new IntroduceOuterClassReferencesTransform(context), new RewriteInnerClassConstructorCalls(context), new RemoveRedundantInitializersTransform(context), new FlattenElseIfStatementsTransform(context), new FlattenSwitchBlocksTransform(context), new IntroduceInitializersTransform(context), new MarkReferencedSyntheticsTransform(context), new RemoveRedundantCastsTransform(context), new InsertNecessaryConversionsTransform(context), new IntroduceStringConcatenationTransform(context), new SimplifyAssignmentsTransform(context), new InlineEscapingAssignmentsTransform(context), new VarArgsTransform(context), new InsertConstantReferencesTransform(context), new SimplifyArithmeticExpressionsTransform(context), new DeclareLocalClassesTransform(context), new InsertOverrideAnnotationsTransform(context), new AddReferenceQualifiersTransform(context), new RemoveHiddenMembersTransform(context), new CollapseImportsTransform(context)};
    }

    public static void runTransformationsUntil(AstNode node, Predicate<IAstTransform> abortCondition, DecompilerContext context) {
        if (node == null) {
            return;
        }
        for (IAstTransform transform : TransformationPipeline.createPipeline(context)) {
            if (abortCondition != null && abortCondition.test((Object)transform)) {
                return;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Running Java AST transform: " + transform.getClass().getSimpleName() + "...");
            }
            transform.run(node);
        }
    }
}

