/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.FSComparators;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.admin.LinearTypeOrder;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CopyOnWriteIndexPart;
import org.apache.uima.cas.impl.FSIndexComparatorImpl;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.FsIndex_bag;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeImpl_annotBase;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.cas.TOP;

public abstract class FsIndex_singletype<T extends FeatureStructure>
extends AbstractCollection<T>
implements Comparator<FeatureStructure>,
LowLevelIndex<T> {
    private static final String[] indexTypes = new String[]{"Sorted", "Set", "Bag", "DefaultBag"};
    private static final WeakHashMap<FSIndexComparatorImpl, WeakReference<FSIndexComparatorImpl>> comparatorCache = new WeakHashMap();
    private final int indexType;
    protected final CASImpl casImpl;
    protected final FSIndexComparatorImpl comparatorForIndexSpecs;
    protected final Comparator<TOP> comparatorWithID;
    protected final Comparator<TOP> comparatorWithoutID;
    protected final Comparator<TOP> comparatorNoTypeWithID;
    protected final Comparator<TOP> comparatorNoTypeWithoutID;
    public final boolean isAnnotIdx;
    private final Object[] keys;
    private final int[] keyTypeCodes;
    private final boolean[] isReverse;
    protected final TypeImpl type;
    private final int typeCode;
    protected WeakReference<CopyOnWriteIndexPart<T>> wr_cow = null;
    private static final AtomicInteger strictTypeSourceCheckMessageCount = new AtomicInteger(0);

    @Override
    public String toString() {
        String kind = this.indexType >= 0 && this.indexType < 4 ? indexTypes[this.indexType] : "Invalid";
        return this.getClass().getSimpleName() + "(" + kind + ")[" + this.type.getShortName() + "]";
    }

    protected FsIndex_singletype(CASImpl cas, Type type, int indexType, FSIndexComparator comparatorForIndexSpecs) {
        this.indexType = indexType;
        this.casImpl = cas;
        this.type = (TypeImpl)type;
        this.typeCode = ((TypeImpl)type).getCode();
        FSIndexComparatorImpl compForIndexSpecs = (FSIndexComparatorImpl)comparatorForIndexSpecs;
        this.comparatorForIndexSpecs = Misc.shareExisting(compForIndexSpecs, comparatorCache);
        int nKeys = this.comparatorForIndexSpecs.getNumberOfKeys();
        this.keys = new Object[nKeys];
        this.keyTypeCodes = new int[nKeys];
        this.isReverse = new boolean[nKeys];
        if (!this.comparatorForIndexSpecs.isValid()) {
            this.isAnnotIdx = false;
            this.comparatorWithID = null;
            this.comparatorWithoutID = null;
            this.comparatorNoTypeWithID = null;
            this.comparatorNoTypeWithoutID = null;
            return;
        }
        for (int i = 0; i < nKeys; ++i) {
            Object k;
            int keyType = comparatorForIndexSpecs.getKeyType(i);
            this.keys[i] = k = keyType == 0 ? this.comparatorForIndexSpecs.getKeyFeature(i) : this.comparatorForIndexSpecs.getKeyTypeOrder(i);
            if (k instanceof FeatureImpl) {
                this.keyTypeCodes[i] = ((TypeImpl)((FeatureImpl)k).getRange()).getCode();
            }
            this.isReverse[i] = this.comparatorForIndexSpecs.getKeyComparator(i) == 1;
        }
        FSIndexRepositoryImpl ir = this.casImpl.indexRepository;
        if (ir.isAnnotationIndex(comparatorForIndexSpecs, indexType)) {
            this.comparatorWithID = ir.getAnnotationFsComparator(FSComparators.WITH_ID, FSComparators.WITH_TYPE_ORDER);
            this.comparatorWithoutID = ir.getAnnotationFsComparator(FSComparators.WITHOUT_ID, FSComparators.WITH_TYPE_ORDER);
            this.comparatorNoTypeWithID = ir.getAnnotationFsComparator(FSComparators.WITH_ID, FSComparators.WITHOUT_TYPE_ORDER);
            this.comparatorNoTypeWithoutID = ir.getAnnotationFsComparator(FSComparators.WITHOUT_ID, FSComparators.WITHOUT_TYPE_ORDER);
            this.isAnnotIdx = true;
        } else {
            this.isAnnotIdx = false;
            if (indexType == 2) {
                this.comparatorWithID = this.comparatorWithoutID = (o1, o2) -> ((FsIndex_bag)this).compare((FeatureStructure)o1, (FeatureStructure)o2);
                this.comparatorNoTypeWithoutID = this.comparatorWithoutID;
                this.comparatorNoTypeWithID = this.comparatorWithoutID;
            } else {
                this.comparatorWithoutID = (o1, o2) -> this.compare((FeatureStructure)o1, (FeatureStructure)o2, false);
                this.comparatorWithID = indexType == 0 ? (o1, o2) -> {
                    int c = this.compare((FeatureStructure)o1, (FeatureStructure)o2, false);
                    return c == 0 ? Integer.compare(o1._id(), o2._id()) : c;
                } : this.comparatorWithoutID;
                this.comparatorNoTypeWithoutID = (o1, o2) -> this.compare((FeatureStructure)o1, (FeatureStructure)o2, true);
                this.comparatorNoTypeWithID = indexType == 0 ? (o1, o2) -> {
                    int c = this.compare((FeatureStructure)o1, (FeatureStructure)o2, true);
                    return c == 0 ? Integer.compare(o1._id(), o2._id()) : c;
                } : this.comparatorWithID;
            }
        }
    }

    abstract void insert(T var1);

    abstract boolean deleteFS(T var1);

    @Override
    public LowLevelIterator<T> iterator(FeatureStructure initialPositionFs) {
        FSIterator fsIt = this.iterator();
        fsIt.moveTo(initialPositionFs);
        return fsIt;
    }

    @Override
    public Comparator<TOP> getComparator() {
        return this.comparatorWithoutID;
    }

    @Override
    public FSIndexComparator getComparatorForIndexSpecs() {
        return this.comparatorForIndexSpecs;
    }

    public FSIndexComparatorImpl getComparatorImplForIndexSpecs() {
        return this.comparatorForIndexSpecs;
    }

    @Override
    public int getIndexingStrategy() {
        return this.indexType;
    }

    @Override
    public int ll_compare(int fs1, int fs2) {
        return this.compare(fs1, fs2);
    }

    @Override
    public int compare(int fs1, int fs2) {
        return this.compare((FeatureStructure)this.casImpl.getFsFromId_checked(fs1), (FeatureStructure)this.casImpl.getFsFromId_checked(fs2));
    }

    int compare(FeatureStructure afs1, FeatureStructure afs2, boolean ignoreType) {
        if (afs1 == afs2) {
            return 0;
        }
        FeatureStructureImplC fs1 = (FeatureStructureImplC)afs1;
        FeatureStructureImplC fs2 = (FeatureStructureImplC)afs2;
        int i = -1;
        for (Object key : this.keys) {
            int result = 0;
            ++i;
            if (key instanceof FeatureImpl) {
                FeatureImpl fi = (FeatureImpl)key;
                if (fi.getRange().isStringOrStringSubtype()) {
                    result = Misc.compareStrings(fs1._getStringValueNc(fi), fs2._getStringValueNc(fi));
                } else {
                    switch (this.keyTypeCodes[i]) {
                        case 23: {
                            result = Integer.compare(fs1._getBooleanValueNc(fi) ? 1 : 0, fs2._getBooleanValueNc(fi) ? 1 : 0);
                            break;
                        }
                        case 24: {
                            result = Integer.compare(fs1._getByteValueNc(fi), fs2._getByteValueNc(fi));
                            break;
                        }
                        case 25: {
                            result = Integer.compare(fs1._getShortValueNc(fi), fs2._getShortValueNc(fi));
                            break;
                        }
                        case 2: {
                            result = Integer.compare(fs1._getIntValueNc(fi), fs2._getIntValueNc(fi));
                            break;
                        }
                        case 26: {
                            result = Long.compare(fs1._getLongValueNc(fi), fs2._getLongValueNc(fi));
                            break;
                        }
                        case 3: {
                            result = Float.compare(fs1._getFloatValueNc(fi), fs2._getFloatValueNc(fi));
                            break;
                        }
                        case 27: {
                            result = Double.compare(fs1._getDoubleValueNc(fi), fs2._getDoubleValueNc(fi));
                        }
                    }
                }
            } else {
                result = ignoreType ? 0 : ((LinearTypeOrder)key).compare(fs1, fs2);
            }
            if (result == 0) continue;
            return this.isReverse[i] ? (result < 0 ? 1 : -1) : (result > 0 ? 1 : -1);
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comparatorForIndexSpecs == null ? 0 : this.comparatorForIndexSpecs.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FsIndex_singletype other = (FsIndex_singletype)obj;
        return !(this.comparatorForIndexSpecs == null ? other.comparatorForIndexSpecs != null : !this.comparatorForIndexSpecs.equals(other.comparatorForIndexSpecs));
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public TypeImpl getTypeImpl() {
        return this.type;
    }

    int getTypeCode() {
        return this.typeCode;
    }

    protected abstract void bulkAddTo(List<T> var1);

    @Override
    public LowLevelIterator<T> ll_iterator(boolean ambiguous) {
        if (ambiguous) {
            return this.ll_iterator();
        }
        return null;
    }

    @Override
    public CASImpl getCasImpl() {
        return this.casImpl;
    }

    @Override
    public FSIndex<T> withSnapshotIterators() {
        return this;
    }

    boolean isSetOrSorted() {
        return this.indexType == 1 || this.indexType == 0;
    }

    @Override
    public boolean isSorted() {
        return this.indexType == 0;
    }

    void removeAll() {
        FSIterator it = this.iterator();
        if (this.type instanceof TypeImpl_annotBase) {
            while (it.hasNext()) {
                ((TOP)it.nextNvc())._resetInSetSortedIndex();
            }
        }
        this.flush();
    }

    protected CopyOnWriteIndexPart<T> getNonNullCow() {
        CopyOnWriteIndexPart<T> n = this.getCopyOnWriteIndexPart();
        if (n != null) {
            return n;
        }
        n = this.createCopyOnWriteIndexPart();
        this.wr_cow = new WeakReference<CopyOnWriteIndexPart<CopyOnWriteIndexPart<T>>>(n);
        return n;
    }

    public CopyOnWriteIndexPart<T> getCopyOnWriteIndexPart() {
        return this.wr_cow == null ? null : (CopyOnWriteIndexPart)this.wr_cow.get();
    }

    protected abstract CopyOnWriteIndexPart<T> createCopyOnWriteIndexPart();

    protected void maybeCopy() {
        if (this.wr_cow != null) {
            CopyOnWriteIndexPart v = (CopyOnWriteIndexPart)this.wr_cow.get();
            if (v != null) {
                v.makeReadOnlyCopy();
            }
            this.wr_cow = null;
        }
    }

    @Override
    public void flush() {
        this.wr_cow = null;
    }

    @Override
    public abstract int compare(FeatureStructure var1, FeatureStructure var2);

    protected final void assertFsTypeMatchesIndexType(FeatureStructure fs, String operation) {
        TypeImpl fsType = ((TOP)fs)._getTypeImpl();
        if (fsType != this.type) {
            String message = String.format("%s operation using a feature structure of type [%s](%d) from type system [%s] on index using different type system [%s] is not supported.", operation, fsType.getName(), fsType.getCode(), String.format("<%,d>", System.identityHashCode(fsType.getTypeSystem())), String.format("<%,d>", System.identityHashCode(this.type.getTypeSystem())));
            if (TypeSystemImpl.IS_ENABLE_STRICT_TYPE_SOURCE_CHECK) {
                throw new IllegalArgumentException(message);
            }
            Misc.decreasingWithTrace(strictTypeSourceCheckMessageCount, message, UIMAFramework.getLogger());
        }
    }
}

