/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.CommonList;
import org.apache.uima.jcas.cas.EmptyStringList;
import org.apache.uima.jcas.cas.NonEmptyStringList;
import org.apache.uima.jcas.cas.TOP;

public abstract class StringList
extends TOP
implements CommonList,
Iterable<String> {
    @Override
    public Iterator<String> iterator() {
        return Collections.emptyIterator();
    }

    protected StringList() {
    }

    public StringList(JCas jcas) {
        super(jcas);
    }

    public StringList(TypeImpl t, CASImpl c) {
        super(t, c);
    }

    public String getNthElement(int i) {
        return ((NonEmptyStringList)this.getNonEmptyNthNode(i)).getHead();
    }

    @Override
    public NonEmptyStringList createNonEmptyNode() {
        NonEmptyStringList node = new NonEmptyStringList(this._casView.getTypeSystemImpl().stringNeListType, this._casView);
        return node;
    }

    public NonEmptyStringList push(String item) {
        return new NonEmptyStringList(this._casView.getJCasImpl(), item, this);
    }

    @Override
    public EmptyStringList emptyList() {
        return this._casView.emptyStringList();
    }

    public static StringList create(JCas jcas, String[] a) {
        StringList stringList = jcas.getCasImpl().emptyStringList();
        for (int i = a.length - 1; i >= 0; --i) {
            stringList = stringList.push(a[i]);
        }
        return stringList;
    }

    public Stream<String> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean contains(String v) {
        StringList node = this;
        while (node instanceof NonEmptyStringList) {
            NonEmptyStringList n = (NonEmptyStringList)node;
            if (Misc.equalStrings(v, n.getHead())) {
                return true;
            }
            node = n.getTail();
        }
        return false;
    }
}

