/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.impl;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.IntFunction;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.impl.JCasHashMap;
import org.apache.uima.util.IteratorNvc;

class JCasHashMapSubMap
implements Iterable<TOP> {
    private static final boolean TUNE = false;
    private static final int PROBE_ADDR_INDEX = 0;
    private static final int PROBE_DELTA_INDEX = 1;
    static final ThreadLocal<int[]> probeInfoGet = new ThreadLocal<int[]>(){

        @Override
        protected int[] initialValue() {
            return new int[2];
        }
    };
    static final ThreadLocal<int[]> probeInfoPutInner = new ThreadLocal<int[]>(){

        @Override
        protected int[] initialValue() {
            return new int[2];
        }
    };
    int[] histogram;
    int maxProbe = 0;
    int maxProbeAfterContinue = 0;
    int continues = 0;
    private final Object synclock = new Object();
    private int sizeWhichTriggersExpansion;
    int size;
    volatile TOP[] table;
    private boolean secondTimeShrinkable = false;
    private final float loadFactor;
    private final int subMapInitialCapacity;
    private final int concurrencyLevelBits;

    JCasHashMapSubMap(float loadFactor, int subMapInitialCapacity, int concurrencyLevelBits) {
        this.loadFactor = loadFactor;
        this.subMapInitialCapacity = subMapInitialCapacity;
        this.concurrencyLevelBits = concurrencyLevelBits;
        this.newTable(subMapInitialCapacity);
    }

    private JCasHashMapSubMap newTable(int capacity) {
        this.table = this.newTableKeepSize(capacity);
        this.size = 0;
        return this;
    }

    private TOP[] newTableKeepSize(int capacity) {
        assert (Integer.bitCount(capacity) == 1);
        TOP[] t = new TOP[capacity];
        this.sizeWhichTriggersExpansion = (int)((float)capacity * this.loadFactor);
        return t;
    }

    private void incrementSize() {
        if (this.size >= this.sizeWhichTriggersExpansion) {
            this.increaseTableCapacity();
        }
        ++this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.synclock;
        synchronized (object) {
            if (this.size < this.sizeWhichTriggersExpansion >>> 1) {
                if (this.secondTimeShrinkable) {
                    this.secondTimeShrinkable = false;
                    int newCapacity = Math.max(this.subMapInitialCapacity, this.table.length >>> 1);
                    if (newCapacity < this.table.length) {
                        this.newTable(newCapacity);
                    } else {
                        Arrays.fill(this.table, null);
                    }
                    this.size = 0;
                    return;
                }
                this.secondTimeShrinkable = true;
            } else {
                this.secondTimeShrinkable = false;
            }
            this.size = 0;
            Arrays.fill(this.table, null);
        }
    }

    private TOP find(TOP[] localTable, int key, int hash, int[] probeInfo) {
        boolean nbrProbes = true;
        int localTblLength = localTable.length;
        int bitMask = localTblLength - 1;
        int startProbe = probeInfo[0];
        boolean isInitialProbe = startProbe == -1;
        boolean isContinue = false;
        int probeAddr = isInitialProbe ? hash & bitMask : startProbe;
        int probeDelta = probeInfo[1];
        assert (probeDelta > 0);
        TOP m = localTable[probeAddr];
        while (true) {
            if (m == null) {
                JCasHashMapSubMap.setProbeInfo(probeInfo, probeAddr, probeDelta);
                return null;
            }
            if (m._id() == key) {
                JCasHashMapSubMap.setProbeInfo(probeInfo, probeAddr, probeDelta);
                return m;
            }
            probeAddr = bitMask & probeAddr + probeDelta;
            m = localTable[probeAddr];
            if (probeDelta >= 11) continue;
            ++probeDelta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHistogram(int nbrProbes, boolean isContinue) {
        Object object = this.synclock;
        synchronized (object) {
            int n = nbrProbes;
            this.histogram[n] = this.histogram[n] + 1;
            if (this.maxProbe < nbrProbes) {
                this.maxProbe = nbrProbes;
            }
            if (isContinue) {
                if (this.maxProbeAfterContinue < nbrProbes) {
                    this.maxProbeAfterContinue = nbrProbes;
                }
                ++this.continues;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TOP putIfAbsent(int key, int hash, IntFunction<TOP> creatorFromKey) {
        int[] probeInfo = probeInfoGet.get();
        JCasHashMapSubMap.resetProbeInfo(probeInfo);
        TOP[] localTable = this.table;
        TOP m = this.find(this.table, key, hash, probeInfo);
        if (m != null && !m._isJCasHashMapReserve()) {
            return m;
        }
        Object object = this.synclock;
        synchronized (object) {
            TOP reserve;
            m = this.re_find(localTable, key, hash, probeInfo);
            if (m != null) {
                assert (!m._isJCasHashMapReserve());
                return m;
            }
            this.table[probeInfo[0]] = reserve = TOP._createJCasHashMapReserve(key);
            localTable = this.table;
            int saved_reserved_index = probeInfo[0];
            this.incrementSize();
            m = creatorFromKey.apply(key);
            if (localTable == this.table) {
                assert (this.table[saved_reserved_index] == reserve || this.table[saved_reserved_index] == m);
                this.table[saved_reserved_index] = m;
            } else {
                JCasHashMapSubMap.resetProbeInfo(probeInfo);
                TOP r = this.find(this.table, key, hash, probeInfo);
                assert (JCasHashMapSubMap.isReserve(r) || r == m);
                this.table[probeInfo[0]] = m;
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TOP put(int key, TOP value, int hash) {
        int[] probeInfo = probeInfoGet.get();
        JCasHashMapSubMap.resetProbeInfo(probeInfo);
        Object object = this.synclock;
        synchronized (object) {
            TOP previous = this.find(this.table, key, hash, probeInfo);
            if (previous != value) {
                this.table[probeInfo[0]] = value;
            }
            if (previous == null) {
                this.incrementSize();
            }
            return previous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TOP get(int key, int hash) {
        int[] probeInfo = probeInfoGet.get();
        JCasHashMapSubMap.resetProbeInfo(probeInfo);
        TOP[] localTable = this.table;
        TOP m = this.find(localTable, key, hash, probeInfo);
        if (m != null && !JCasHashMapSubMap.isReserve(m)) {
            return m;
        }
        Object object = this.synclock;
        synchronized (object) {
            m = this.re_find(localTable, key, hash, probeInfo);
        }
        return m;
    }

    private void putInner(int key, TOP value, int hash, int[] probeInfo) {
        JCasHashMapSubMap.resetProbeInfo(probeInfo);
        TOP[] localTable = this.table;
        TOP m = this.find(localTable, key, hash, probeInfo);
        assert (m == null);
        localTable[probeInfo[0]] = value;
    }

    private void increaseTableCapacity() {
        TOP[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        int newCapacity = 2 * oldCapacity;
        this.table = this.newTableKeepSize(newCapacity);
        int[] probeInfo = probeInfoPutInner.get();
        for (int i = 0; i < oldCapacity; ++i) {
            TOP fs = oldTable[i];
            if (fs == null) continue;
            int key = fs._id();
            int hash = JCasHashMap.hashInt(key);
            this.putInner(key, fs, hash >>> this.concurrencyLevelBits, probeInfo);
        }
    }

    private static boolean isReserve(TOP m) {
        return m != null && m._isJCasHashMapReserve();
    }

    private static void resetProbeInfo(int[] probeInfo) {
        probeInfo[0] = -1;
        probeInfo[1] = 1;
    }

    private static void setProbeInfo(int[] probeInfo, int probeAddr, int probeDelta) {
        probeInfo[0] = probeAddr;
        probeInfo[1] = probeDelta;
    }

    private TOP re_find(TOP[] localTable, int key, int hash, int[] probeInfo) {
        if (localTable != this.table) {
            JCasHashMapSubMap.resetProbeInfo(probeInfo);
        }
        return this.find(this.table, key, hash, probeInfo);
    }

    @Override
    public IteratorNvc<TOP> iterator() {
        return new IteratorNvc<TOP>(){
            int i = this.moveToNextValid(0);

            @Override
            public boolean hasNext() {
                return this.i < JCasHashMapSubMap.this.table.length;
            }

            @Override
            public TOP next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.nextNvc();
            }

            @Override
            public TOP nextNvc() {
                TOP r = JCasHashMapSubMap.this.table[this.i];
                this.i = this.moveToNextValid(this.i + 1);
                return r;
            }

            int moveToNextValid(int pos) {
                while (pos < JCasHashMapSubMap.this.table.length && (JCasHashMapSubMap.this.table[pos] == null || JCasHashMapSubMap.this.table[pos]._isJCasHashMapReserve())) {
                    ++pos;
                }
                return pos;
            }
        };
    }
}

