/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ExecutableValidator;
import jakarta.validation.metadata.ConstraintDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.Conventions;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DefaultMessageCodesResolver;
import org.springframework.validation.Errors;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.annotation.Validated;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;
import org.springframework.validation.method.MethodValidationResult;
import org.springframework.validation.method.MethodValidator;
import org.springframework.validation.method.ParameterErrors;
import org.springframework.validation.method.ParameterValidationResult;

public class MethodValidationAdapter
implements MethodValidator {
    private static final MethodValidationResult emptyValidationResult = MethodValidationResult.emptyResult();
    private static final ObjectNameResolver defaultObjectNameResolver = new DefaultObjectNameResolver();
    private static final Comparator<ParameterValidationResult> resultComparator = new ResultComparator();
    private final Supplier<Validator> validator;
    private final Supplier<SpringValidatorAdapter> validatorAdapter;
    private MessageCodesResolver messageCodesResolver = new DefaultMessageCodesResolver();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private ObjectNameResolver objectNameResolver = defaultObjectNameResolver;

    public MethodValidationAdapter() {
        this.validator = SingletonSupplier.of(() -> Validation.buildDefaultValidatorFactory().getValidator());
        this.validatorAdapter = MethodValidationAdapter.initValidatorAdapter(this.validator);
    }

    public MethodValidationAdapter(ValidatorFactory validatorFactory) {
        if (validatorFactory instanceof SpringValidatorAdapter) {
            SpringValidatorAdapter adapter = (SpringValidatorAdapter)validatorFactory;
            this.validator = () -> adapter;
            this.validatorAdapter = () -> adapter;
        } else {
            this.validator = SingletonSupplier.of(() -> ((ValidatorFactory)validatorFactory).getValidator());
            this.validatorAdapter = SingletonSupplier.of(() -> new SpringValidatorAdapter(this.validator.get()));
        }
    }

    public MethodValidationAdapter(Validator validator) {
        this.validator = () -> validator;
        this.validatorAdapter = MethodValidationAdapter.initValidatorAdapter(this.validator);
    }

    public MethodValidationAdapter(Supplier<Validator> validator) {
        this.validator = validator;
        this.validatorAdapter = MethodValidationAdapter.initValidatorAdapter(validator);
    }

    private static Supplier<SpringValidatorAdapter> initValidatorAdapter(Supplier<Validator> validatorSupplier) {
        return SingletonSupplier.of(() -> {
            SpringValidatorAdapter sva;
            Validator validator = (Validator)validatorSupplier.get();
            return validator instanceof SpringValidatorAdapter ? (sva = (SpringValidatorAdapter)validator) : new SpringValidatorAdapter(validator);
        });
    }

    public Supplier<SpringValidatorAdapter> getSpringValidatorAdapter() {
        return this.validatorAdapter;
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.messageCodesResolver = messageCodesResolver;
    }

    public MessageCodesResolver getMessageCodesResolver() {
        return this.messageCodesResolver;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public ParameterNameDiscoverer getParameterNameDiscoverer() {
        return this.parameterNameDiscoverer;
    }

    public void setObjectNameResolver(ObjectNameResolver nameResolver) {
        this.objectNameResolver = nameResolver;
    }

    @Override
    public Class<?>[] determineValidationGroups(Object target, Method method) {
        Validated validatedAnn = (Validated)AnnotationUtils.findAnnotation((Method)method, Validated.class);
        if (validatedAnn == null) {
            if (AopUtils.isAopProxy((Object)target)) {
                Class type;
                Class[] classArray = AopProxyUtils.proxiedUserInterfaces((Object)target);
                int n = classArray.length;
                for (int i = 0; i < n && (validatedAnn = (Validated)AnnotationUtils.findAnnotation((Class)(type = classArray[i]), Validated.class)) == null; ++i) {
                }
            } else {
                validatedAnn = (Validated)AnnotationUtils.findAnnotation(target.getClass(), Validated.class);
            }
        }
        return validatedAnn != null ? validatedAnn.value() : new Class[]{};
    }

    @Override
    public final MethodValidationResult validateArguments(Object target, Method method, @Nullable MethodParameter[] parameters, Object[] arguments, Class<?>[] groups) {
        Set<ConstraintViolation<Object>> violations = this.invokeValidatorForArguments(target, method, arguments, groups);
        if (violations.isEmpty()) {
            return emptyValidationResult;
        }
        return this.adaptViolations(target, method, violations, i -> parameters != null ? parameters[i] : this.initMethodParameter(method, (int)i), i -> arguments[i]);
    }

    public final Set<ConstraintViolation<Object>> invokeValidatorForArguments(Object target, Method method, Object[] arguments, Class<?>[] groups) {
        ExecutableValidator execVal = this.validator.get().forExecutables();
        try {
            return execVal.validateParameters(target, method, arguments, (Class[])groups);
        }
        catch (IllegalArgumentException ex) {
            Method bridgedMethod = BridgeMethodResolver.getMostSpecificMethod((Method)method, target.getClass());
            return execVal.validateParameters(target, bridgedMethod, arguments, (Class[])groups);
        }
    }

    @Override
    public final MethodValidationResult validateReturnValue(Object target, Method method, @Nullable MethodParameter returnType, @Nullable Object returnValue, Class<?>[] groups) {
        Set<ConstraintViolation<Object>> violations = this.invokeValidatorForReturnValue(target, method, returnValue, groups);
        if (violations.isEmpty()) {
            return emptyValidationResult;
        }
        return this.adaptViolations(target, method, violations, i -> returnType != null ? returnType : this.initMethodParameter(method, -1), i -> returnValue);
    }

    public final Set<ConstraintViolation<Object>> invokeValidatorForReturnValue(Object target, Method method, @Nullable Object returnValue, Class<?>[] groups) {
        ExecutableValidator execVal = this.validator.get().forExecutables();
        return execVal.validateReturnValue(target, method, returnValue, (Class[])groups);
    }

    private MethodValidationResult adaptViolations(Object target, Method method, Set<ConstraintViolation<Object>> violations, Function<Integer, MethodParameter> parameterFunction, Function<Integer, Object> argumentFunction) {
        LinkedHashMap<Path.Node, ParamValidationResultBuilder> paramViolations = new LinkedHashMap<Path.Node, ParamValidationResultBuilder>();
        LinkedHashMap<Path.Node, ParamErrorsBuilder> nestedViolations = new LinkedHashMap<Path.Node, ParamErrorsBuilder>();
        ArrayList<MessageSourceResolvable> crossParamErrors = null;
        block0: for (ConstraintViolation<Object> violation : violations) {
            Iterator nodes = violation.getPropertyPath().iterator();
            while (nodes.hasNext()) {
                Object container;
                Object value;
                MethodParameter parameter;
                Path.Node node = (Path.Node)nodes.next();
                if (node.getKind().equals((Object)ElementKind.PARAMETER)) {
                    int index = ((Path.ParameterNode)node.as(Path.ParameterNode.class)).getParameterIndex();
                    parameter = parameterFunction.apply(index);
                } else if (node.getKind().equals((Object)ElementKind.RETURN_VALUE)) {
                    parameter = parameterFunction.apply(-1);
                } else {
                    if (!node.getKind().equals((Object)ElementKind.CROSS_PARAMETER)) continue;
                    crossParamErrors = crossParamErrors != null ? crossParamErrors : new ArrayList<MessageSourceResolvable>();
                    crossParamErrors.add(this.createCrossParamError(target, method, violation));
                    continue block0;
                }
                Object[] arg = argumentFunction.apply(parameter.getParameterIndex());
                Path.Node parameterNode = node;
                if (nodes.hasNext()) {
                    node = (Path.Node)nodes.next();
                }
                Integer index = node.getIndex();
                Object key2 = node.getKey();
                if (index != null && arg instanceof List) {
                    List list = (List)arg;
                    value = list.get(index);
                    container = list;
                } else if (index != null && arg instanceof Object[]) {
                    Object[] array = arg;
                    value = array[index];
                    container = array;
                } else if (key2 != null && arg instanceof Map) {
                    Map map = (Map)arg;
                    value = map.get(key2);
                    container = map;
                } else if (arg instanceof Iterable) {
                    value = arg;
                    container = arg;
                } else if (arg instanceof Optional) {
                    Optional optional = (Optional)arg;
                    value = optional.orElse(null);
                    container = optional;
                } else {
                    value = arg;
                    container = null;
                }
                if (node.getKind().equals((Object)ElementKind.PROPERTY) || node.getKind().equals((Object)ElementKind.BEAN)) {
                    nestedViolations.computeIfAbsent(parameterNode, k -> new ParamErrorsBuilder(parameter, value, container, index, key2)).addViolation(violation);
                    continue block0;
                }
                paramViolations.computeIfAbsent(parameterNode, p -> new ParamValidationResultBuilder(target, parameter, value, container, index, key2)).addViolation(violation);
                continue block0;
            }
        }
        ArrayList<ParameterValidationResult> resultList = new ArrayList<ParameterValidationResult>();
        paramViolations.forEach((param, builder) -> resultList.add(builder.build()));
        nestedViolations.forEach((key, builder) -> resultList.add(builder.build()));
        resultList.sort(resultComparator);
        return MethodValidationResult.create(target, method, resultList, crossParamErrors != null ? crossParamErrors : Collections.emptyList());
    }

    private MethodParameter initMethodParameter(Method method, int index) {
        MethodParameter parameter = new MethodParameter(method, index);
        parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
        return parameter;
    }

    private MessageSourceResolvable createMessageSourceResolvable(Object target, MethodParameter parameter, ConstraintViolation<Object> violation) {
        String objectName = Conventions.getVariableName((Object)target) + "#" + parameter.getExecutable().getName();
        String paramName = parameter.getParameterName() != null ? parameter.getParameterName() : "";
        Class parameterType = parameter.getParameterType();
        ConstraintDescriptor descriptor = violation.getConstraintDescriptor();
        String code = descriptor.getAnnotation().annotationType().getSimpleName();
        String[] codes = this.messageCodesResolver.resolveMessageCodes(code, objectName, paramName, parameterType);
        Object[] arguments = this.validatorAdapter.get().getArgumentsForConstraint(objectName, paramName, descriptor);
        return new ViolationMessageSourceResolvable(codes, arguments, violation.getMessage(), violation);
    }

    private BindingResult createBindingResult(MethodParameter parameter, @Nullable Object argument) {
        String objectName = this.objectNameResolver.resolveName(parameter, argument);
        BeanPropertyBindingResult result = new BeanPropertyBindingResult(argument, objectName);
        result.setMessageCodesResolver(this.messageCodesResolver);
        return result;
    }

    private MessageSourceResolvable createCrossParamError(Object target, Method method, ConstraintViolation<Object> violation) {
        String objectName = Conventions.getVariableName((Object)target) + "#" + method.getName();
        ConstraintDescriptor descriptor = violation.getConstraintDescriptor();
        String code = descriptor.getAnnotation().annotationType().getSimpleName();
        String[] codes = this.messageCodesResolver.resolveMessageCodes(code, objectName);
        Object[] arguments = this.validatorAdapter.get().getArgumentsForConstraint(objectName, "", descriptor);
        return new ViolationMessageSourceResolvable(codes, arguments, violation.getMessage(), violation);
    }

    public static interface ObjectNameResolver {
        public String resolveName(MethodParameter var1, @Nullable Object var2);
    }

    private final class ParamErrorsBuilder {
        private final MethodParameter parameter;
        @Nullable
        private final Object bean;
        @Nullable
        private final Object container;
        @Nullable
        private final Integer containerIndex;
        @Nullable
        private final Object containerKey;
        private final Errors errors;
        private final Set<ConstraintViolation<Object>> violations = new LinkedHashSet<ConstraintViolation<Object>>();

        public ParamErrorsBuilder(@Nullable MethodParameter param, @Nullable Object bean2, @Nullable Object container, @Nullable Integer containerIndex, Object containerKey) {
            this.parameter = param;
            this.bean = bean2;
            this.container = container;
            this.containerIndex = containerIndex;
            this.containerKey = containerKey;
            this.errors = MethodValidationAdapter.this.createBindingResult(param, this.bean);
        }

        public void addViolation(ConstraintViolation<Object> violation) {
            this.violations.add(violation);
        }

        public ParameterErrors build() {
            MethodValidationAdapter.this.validatorAdapter.get().processConstraintViolations(this.violations, this.errors);
            return new ParameterErrors(this.parameter, this.bean, this.errors, this.container, this.containerIndex, this.containerKey);
        }
    }

    private final class ParamValidationResultBuilder {
        private final Object target;
        private final MethodParameter parameter;
        @Nullable
        private final Object value;
        @Nullable
        private final Object container;
        @Nullable
        private final Integer containerIndex;
        @Nullable
        private final Object containerKey;
        private final List<MessageSourceResolvable> resolvableErrors = new ArrayList<MessageSourceResolvable>();

        public ParamValidationResultBuilder(Object target, @Nullable MethodParameter parameter, @Nullable Object value, @Nullable Object container, @Nullable Integer containerIndex, Object containerKey) {
            this.target = target;
            this.parameter = parameter;
            this.value = value;
            this.container = container;
            this.containerIndex = containerIndex;
            this.containerKey = containerKey;
        }

        public void addViolation(ConstraintViolation<Object> violation) {
            this.resolvableErrors.add(MethodValidationAdapter.this.createMessageSourceResolvable(this.target, this.parameter, violation));
        }

        public ParameterValidationResult build() {
            return new ParameterValidationResult(this.parameter, this.value, this.resolvableErrors, this.container, this.containerIndex, this.containerKey, (error, sourceType) -> {
                Assert.isTrue((boolean)sourceType.equals(ConstraintViolation.class), (String)"Unexpected source type");
                return ((ViolationMessageSourceResolvable)error).getViolation();
            });
        }
    }

    private static class ViolationMessageSourceResolvable
    extends DefaultMessageSourceResolvable {
        private final transient ConstraintViolation<Object> violation;

        public ViolationMessageSourceResolvable(String[] codes, Object[] arguments, String defaultMessage, ConstraintViolation<Object> violation) {
            super(codes, arguments, defaultMessage);
            this.violation = violation;
        }

        public ConstraintViolation<Object> getViolation() {
            return this.violation;
        }
    }

    private static class DefaultObjectNameResolver
    implements ObjectNameResolver {
        private DefaultObjectNameResolver() {
        }

        @Override
        public String resolveName(MethodParameter parameter, @Nullable Object value) {
            Object objectName = null;
            if (parameter.getParameterIndex() != -1) {
                objectName = parameter.getParameterName();
            } else {
                try {
                    Method method = parameter.getMethod();
                    if (method != null) {
                        Class containingClass = parameter.getContainingClass();
                        Class resolvedType = GenericTypeResolver.resolveReturnType((Method)method, (Class)containingClass);
                        objectName = Conventions.getVariableNameForReturnType((Method)method, (Class)resolvedType, (Object)value);
                    }
                }
                catch (IllegalArgumentException method) {
                    // empty catch block
                }
            }
            if (objectName == null) {
                int index = parameter.getParameterIndex();
                objectName = parameter.getExecutable().getName() + (String)(index != -1 ? ".arg" + index : ".returnValue");
            }
            return objectName;
        }
    }

    private static final class ResultComparator
    implements Comparator<ParameterValidationResult> {
        private ResultComparator() {
        }

        @Override
        public int compare(ParameterValidationResult result1, ParameterValidationResult result2) {
            int index2;
            int index1 = result1.getMethodParameter().getParameterIndex();
            int i = Integer.compare(index1, index2 = result2.getMethodParameter().getParameterIndex());
            if (i != 0) {
                return i;
            }
            if (result1 instanceof ParameterErrors) {
                ParameterErrors errors1 = (ParameterErrors)result1;
                if (result2 instanceof ParameterErrors) {
                    ParameterErrors errors2 = (ParameterErrors)result2;
                    Integer containerIndex1 = errors1.getContainerIndex();
                    Integer containerIndex2 = errors2.getContainerIndex();
                    if (containerIndex1 != null && containerIndex2 != null && (i = Integer.compare(containerIndex1, containerIndex2)) != 0) {
                        return i;
                    }
                    i = this.compareKeys(errors1, errors2);
                    return i;
                }
            }
            return 0;
        }

        private <E> int compareKeys(ParameterErrors errors1, ParameterErrors errors2) {
            Object key1 = errors1.getContainerKey();
            Object key2 = errors2.getContainerKey();
            if (key1 instanceof Comparable && key2 instanceof Comparable) {
                return ((Comparable)key1).compareTo(key2);
            }
            return 0;
        }
    }
}

