/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.debug;

import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.vinci.debug.AssertionFailedException;

public class Debug {
    private static volatile boolean log_messages = true;
    private static volatile boolean log_exceptions = true;
    private static boolean output_thread_name = false;
    private static PrintStream debugStream = System.err;
    private static DateFormat formatter = DateFormat.getDateTimeInstance(3, 3, Locale.ENGLISH);
    private static Date now = new Date();

    private Debug() {
    }

    public static synchronized void setDebuggingStream(PrintStream w) {
        debugStream = w;
    }

    public static synchronized PrintStream getDebuggingStream() {
        return debugStream;
    }

    public static synchronized void setLogMessages(boolean on) {
        log_messages = on;
        if (on) {
            Debug.p("vinci.debug.Debug", "Message logging turned ON.");
        }
    }

    public static synchronized boolean getLogMessages() {
        return log_messages;
    }

    public static synchronized void setLogExceptions(boolean on) {
        log_exceptions = on;
        Debug.p("vinci.debug.Debug", "Exception logging turned " + (on ? "ON" : "OFF"));
    }

    public static synchronized boolean getLogExceptions() {
        return log_messages;
    }

    public static synchronized void setThreadNameOutput(boolean on) {
        output_thread_name = on;
    }

    public static synchronized void reportException(Throwable e, String message) {
        if (log_exceptions) {
            Debug.printDebuggingMessage("====================================");
            debugStream.println("(WARNING) Unexpected exception: " + message);
            e.printStackTrace(debugStream);
            debugStream.flush();
        }
    }

    public static synchronized void reportException(Throwable e) {
        if (log_exceptions) {
            Debug.printDebuggingMessage("====================================");
            debugStream.println("(WARNING) Unexpected exception: ");
            e.printStackTrace(debugStream);
            debugStream.flush();
        }
    }

    public static synchronized String printDebuggingMessage(String message) {
        if (log_messages) {
            now.setTime(System.currentTimeMillis());
            if (output_thread_name) {
                debugStream.println("[" + formatter.format(now) + " | " + Thread.currentThread().getName() + "] " + message);
            } else {
                debugStream.println("[" + formatter.format(now) + "] " + message);
            }
        }
        return message;
    }

    public static synchronized void printDebuggingMessage(String location, String message) {
        if (log_messages) {
            now.setTime(System.currentTimeMillis());
            if (output_thread_name) {
                debugStream.println("[" + formatter.format(now) + " | " + Thread.currentThread().getName() + "](" + location + ") " + message);
            } else {
                debugStream.println("[" + formatter.format(now) + "](" + location + ") " + message);
            }
        }
    }

    public static String p(String message) {
        return Debug.printDebuggingMessage(message);
    }

    public static void p(String location, String message) {
        Debug.printDebuggingMessage(location, message);
    }

    public static void Assert(boolean check) throws AssertionFailedException {
        if (!check) {
            throw new AssertionFailedException("no message");
        }
    }

    public static void Assert(boolean check, String message) throws AssertionFailedException {
        if (!check) {
            throw new AssertionFailedException(message);
        }
    }

    static synchronized void reportFatalException(Throwable e) {
        if (log_exceptions) {
            Debug.printDebuggingMessage("====================================");
            debugStream.println("(FATAL ERROR) Unexpected exception: ");
            e.printStackTrace(debugStream);
            debugStream.flush();
        }
    }

    public static synchronized void flush() {
        debugStream.flush();
    }
}

