/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.context;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.vinci.debug.Debug;
import org.apache.vinci.transport.ServiceDownException;
import org.apache.vinci.transport.ServiceException;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.TransportableFactory;
import org.apache.vinci.transport.VNSException;
import org.apache.vinci.transport.VinciClient;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.vns.client.ResolveResult;

public class VinciContext {
    public static final int DEFAULT_VNS_CACHE_SIZE = 1000;
    private static final String VNS_HOST_PROPERTY = "VNS_HOST";
    private static final String VNS_HOST_PROPERTY_2 = "VNSHOST";
    private static final String VNS_PORT_PROPERTY = "VNS_PORT";
    private static final String VNS_PORT_PROPERTY_2 = "VNSPORT";
    private static final int DEFAULT_VNS_PORT = 9000;
    private static VinciContext globalContext;
    private static final int DEFAULT_RESOLVE_TIMEOUT = 20000;
    private static final int DEFAULT_SERVEON_TIMEOUT = 60000;
    private static final int DEFAULT_TTL = 60000;
    private int vnsResolveTimeout = 20000;
    private int vnsServeonTimeout = 60000;
    private int ttlMillis = 60000;
    private boolean allowStaleLookups = true;
    private int vnsCacheSize = 1000;
    private String host;
    private int port;
    private boolean socketKeepAliveEnabled = true;
    private LinkedHashMap vnsCache = new LinkedHashMap(16, 0.75f, true){
        private static final long serialVersionUID = 7138871637782205744L;

        protected boolean removeEldestEntry(Map.Entry e) {
            return this.size() > VinciContext.this.vnsCacheSize;
        }
    };

    public synchronized void setVNSCacheSize(int to) {
        this.vnsCacheSize = to;
    }

    public VinciContext(String myhost, int myport) {
        this.host = myhost;
        this.port = myport;
    }

    public String getVNSHost() {
        if (this.host == null) {
            throw new IllegalStateException("No VNS host or IP address has been specified! You can specify the VNS host or IP address through the Java command-line option -DVNS_HOST=[hostname], or programmatically using either System.setProperty(\"VNS_HOST\",[hostname]) or VinciContext.getGlobalContext().setVNSHost([hostname]).");
        }
        return this.host;
    }

    public int getVNSPort() {
        return this.port;
    }

    public void setVNSHost(String h) {
        this.host = h;
        this.flushAll();
    }

    public void setVNSPort(int p) {
        this.port = p;
        this.flushAll();
    }

    public boolean areStaleLookupsAllowed() {
        return this.allowStaleLookups;
    }

    public void setAllowStaleLookups(boolean b) {
        this.allowStaleLookups = b;
    }

    public int getResolveCacheTTL() {
        return this.ttlMillis;
    }

    public void setResolveCacheTTL(int millis) {
        this.ttlMillis = millis;
    }

    public int getVNSResolveTimeout() {
        return this.vnsResolveTimeout;
    }

    public void setVNSResolveTimeout(int millis) {
        this.vnsResolveTimeout = millis;
    }

    public int getVNSServeonTimeout() {
        return this.vnsServeonTimeout;
    }

    public void setVNSServeonTimeout(int millis) {
        this.vnsServeonTimeout = millis;
    }

    public boolean isSocketKeepAliveEnabled() {
        return this.socketKeepAliveEnabled;
    }

    public void setSocketKeepAliveEnabled(boolean b) {
        this.socketKeepAliveEnabled = b;
    }

    public static VinciContext getGlobalContext() {
        return globalContext;
    }

    public synchronized ResolveResult getCachedResolveResult(String serviceName) {
        long now;
        CachedVNSResult r = (CachedVNSResult)this.vnsCache.get(serviceName);
        if (r != null && (now = System.currentTimeMillis()) - r.entryTime <= (long)this.ttlMillis) {
            return r.r;
        }
        return null;
    }

    public synchronized ResolveResult getStaleCachedResolveResult(String serviceName) {
        CachedVNSResult r = (CachedVNSResult)this.vnsCache.get(serviceName);
        if (r != null) {
            return r.r;
        }
        return null;
    }

    public synchronized void cacheResolveResult(String serviceName, ResolveResult r) {
        CachedVNSResult c = (CachedVNSResult)this.vnsCache.get(serviceName);
        if (c == null) {
            this.vnsCache.put(serviceName, new CachedVNSResult(r));
        } else {
            c.r = r;
            c.entryTime = System.currentTimeMillis();
        }
    }

    public synchronized void flushFromCache(String serviceName) {
        this.vnsCache.remove(serviceName);
    }

    public synchronized void flushAll() {
        this.vnsCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transportable sendAndReceive(Transportable in, String service_name, TransportableFactory factory) throws IOException, ServiceException, ServiceDownException, VNSException {
        try (VinciClient tempClient = new VinciClient(service_name, factory, this);){
            Transportable transportable = tempClient.sendAndReceive(in);
            return transportable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transportable sendAndReceive(Transportable in, String service_name, TransportableFactory factory, int socket_timeout) throws IOException, ServiceException {
        tempClient.setSocketTimeout(socket_timeout);
        try (VinciClient tempClient = new VinciClient(service_name, factory, this);){
            Transportable transportable = tempClient.sendAndReceive(in);
            return transportable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transportable sendAndReceive(Transportable in, String service_name, TransportableFactory factory, int socket_timeout, int connect_timeout) throws IOException, ServiceException {
        tempClient.setSocketTimeout(socket_timeout);
        try (VinciClient tempClient = new VinciClient(service_name, factory, this, connect_timeout);){
            Transportable transportable = tempClient.sendAndReceive(in);
            return transportable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VinciFrame rpc(Transportable in, String service_name) throws IOException, ServiceException, ServiceDownException, VNSException {
        try (VinciClient tempClient = new VinciClient(service_name, this);){
            VinciFrame vinciFrame = tempClient.rpc(in);
            return vinciFrame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VinciFrame rpc(Transportable in, String service_name, int timeout) throws IOException, ServiceException, ServiceDownException, VNSException {
        tempClient.setSocketTimeout(timeout);
        try (VinciClient tempClient = new VinciClient(service_name, this);){
            VinciFrame vinciFrame = tempClient.rpc(in);
            return vinciFrame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VinciFrame rpc(Transportable in, String service_name, int socket_timeout, int connect_timeout) throws IOException, ServiceException, ServiceDownException, VNSException {
        tempClient.setSocketTimeout(socket_timeout);
        try (VinciClient tempClient = new VinciClient(service_name, this, connect_timeout);){
            VinciFrame vinciFrame = tempClient.rpc(in);
            return vinciFrame;
        }
    }

    static {
        String host;
        int port;
        String portString = System.getProperty(VNS_PORT_PROPERTY);
        if (portString == null) {
            portString = System.getProperty(VNS_PORT_PROPERTY_2);
        }
        if (portString != null) {
            try {
                port = Integer.parseInt(portString);
            }
            catch (Exception e) {
                Debug.reportException(e);
                port = 9000;
            }
        } else {
            port = 9000;
        }
        if ((host = System.getProperty(VNS_HOST_PROPERTY)) == null) {
            host = System.getProperty(VNS_HOST_PROPERTY_2);
        }
        globalContext = new VinciContext(host, port);
    }

    static class CachedVNSResult {
        ResolveResult r;
        long entryTime;

        CachedVNSResult(ResolveResult r) {
            this.r = r;
            this.entryTime = System.currentTimeMillis();
        }
    }
}

