/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ep_launcher;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XCASDeserializer;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.ep_launcher.LauncherConstants;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLSerializer;
import org.apache.uima.util.impl.ProcessTrace_impl;
import org.xml.sax.SAXException;

public class RemoteLauncher {
    public static final String DESCRIPTOR_PARAM = "-descriptor";
    public static final String INPUT_RESOURCE_PARAM = "-inputResource";
    public static final String INPUT_RECURSIVE_PARAM = "-recursive";
    public static final String INPUT_FORMAT_PARAM = "-format";
    public static final String INPUT_ENCODING_PARAM = "-encoding";
    public static final String INPUT_LANGUAGE_PARAM = "-language";
    public static final String OUTPUT_FOLDER_PARAM = "-output";
    public static final String OUTPUT_CLEAR_PARAM = "-clear";
    private static File descriptor;
    private static File inputResource;
    private static boolean inputRecursive;
    private static LauncherConstants.InputFormat inputFormat;
    private static String inputEncoding;
    private static String inputLanguage;
    private static File outputFolder;
    private static boolean outputFolderClear;

    private static boolean parseCmdLineArgs(String[] args) {
        int necessaryArgCount = 0;
        int index = 0;
        while (index < args.length) {
            String arg;
            if (DESCRIPTOR_PARAM.equals(arg = args[index++])) {
                if (index >= args.length) {
                    return false;
                }
                descriptor = new File(args[index++]);
                ++necessaryArgCount;
                continue;
            }
            if (INPUT_RESOURCE_PARAM.equals(arg)) {
                if (index >= args.length) {
                    return false;
                }
                inputResource = new File(args[index++]);
                ++necessaryArgCount;
                continue;
            }
            if (INPUT_RECURSIVE_PARAM.equals(arg)) {
                if (index >= args.length) {
                    return false;
                }
                inputRecursive = Boolean.parseBoolean(args[index++]);
                continue;
            }
            if (INPUT_FORMAT_PARAM.equals(arg)) {
                if (index >= args.length) {
                    return false;
                }
                String inputFormatName = args[index++];
                if (LauncherConstants.InputFormat.CAS.toString().equals(inputFormatName)) {
                    inputFormat = LauncherConstants.InputFormat.CAS;
                    continue;
                }
                if (LauncherConstants.InputFormat.PLAIN_TEXT.toString().equals(inputFormatName)) {
                    inputFormat = LauncherConstants.InputFormat.PLAIN_TEXT;
                    continue;
                }
                System.err.println("Unkown input format: " + inputFormatName);
                return false;
            }
            if (INPUT_ENCODING_PARAM.equals(arg)) {
                if (index >= args.length) {
                    return false;
                }
                inputEncoding = args[index++];
                continue;
            }
            if (INPUT_LANGUAGE_PARAM.equals(arg)) {
                if (index >= args.length) {
                    return false;
                }
                inputLanguage = args[index++];
                continue;
            }
            if (OUTPUT_FOLDER_PARAM.equals(arg)) {
                if (index >= args.length) {
                    return false;
                }
                outputFolder = new File(args[index++]);
                continue;
            }
            if (!OUTPUT_CLEAR_PARAM.equals(arg)) continue;
            if (index >= args.length) {
                return false;
            }
            outputFolderClear = Boolean.parseBoolean(args[index++]);
        }
        return necessaryArgCount == 2;
    }

    private static void processFile(File inputFile, LauncherConstants.InputFormat format, AnalysisEngine aAE, CAS aCAS) throws IOException, AnalysisEngineProcessException {
        block32: {
            if (LauncherConstants.InputFormat.PLAIN_TEXT.equals((Object)format)) {
                String document = FileUtils.file2String((File)inputFile, (String)inputEncoding);
                document = document.trim();
                aCAS.setDocumentText(document);
                if (inputLanguage != null) {
                    aCAS.setDocumentLanguage(inputLanguage);
                }
            } else if (LauncherConstants.InputFormat.CAS.equals((Object)format)) {
                FileInputStream inputStream;
                if (inputFile.getName().endsWith(".xmi")) {
                    try {
                        inputStream = new FileInputStream(inputFile);
                        try {
                            XmiCasDeserializer.deserialize((InputStream)inputStream, (CAS)aCAS, (boolean)true);
                            break block32;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (SAXException e) {
                        throw new IOException(e.getMessage());
                    }
                }
                if (inputFile.getName().endsWith(".xcas")) {
                    try {
                        inputStream = new FileInputStream(inputFile);
                        try {
                            XCASDeserializer.deserialize((InputStream)inputStream, (CAS)aCAS, (boolean)true);
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (SAXException e) {
                        throw new IOException(e.getMessage());
                    }
                }
            } else {
                throw new IllegalStateException("Unexpected format!");
            }
        }
        aAE.process(aCAS);
        if (outputFolder != null) {
            File outputFile;
            File inputDirectory = inputResource.isFile() ? inputResource.getParentFile() : inputResource;
            String inputFilePath = inputFile.getPath();
            if (!inputFilePath.startsWith(inputDirectory.getPath())) {
                System.err.println("Error: Unable to construct output file path, output file will not be written!");
                return;
            }
            String relativeInputFilePath = inputFilePath.substring(inputDirectory.getPath().length());
            String outputFilePath = new File(outputFolder.getPath(), relativeInputFilePath).getPath();
            int fileTypeIndex = outputFilePath.lastIndexOf(".");
            if (fileTypeIndex != -1) {
                outputFilePath = outputFilePath.substring(0, fileTypeIndex);
            }
            if (!(outputFile = new File(outputFilePath + ".xmi")).getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            try (FileOutputStream out = new FileOutputStream(outputFile);){
                XmiCasSerializer ser = new XmiCasSerializer(aCAS.getTypeSystem());
                XMLSerializer xmlSer = new XMLSerializer((OutputStream)out, false);
                try {
                    ser.serialize(aCAS, xmlSer.getContentHandler());
                }
                catch (SAXException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
        aCAS.reset();
    }

    private static void findAndProcessFiles(File inputResource, FileFilter fileFilter, AnalysisEngine aAE, CAS aCAS) throws IOException, AnalysisEngineProcessException {
        if (inputResource.isDirectory()) {
            File[] files = inputResource.listFiles(fileFilter);
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].isDirectory()) {
                        RemoteLauncher.processFile(files[i], inputFormat, aAE, aCAS);
                        continue;
                    }
                    RemoteLauncher.findAndProcessFiles(files[i], fileFilter, aAE, aCAS);
                }
            }
        } else if (inputResource.isFile()) {
            RemoteLauncher.processFile(inputResource, inputFormat, aAE, aCAS);
        }
    }

    private static boolean deleteFile(File file) {
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            boolean success = true;
            for (File subFile : subFiles) {
                success = success && RemoteLauncher.deleteFile(subFile);
            }
            return success;
        }
        return file.delete();
    }

    public static void main(String[] args) throws Exception {
        FileFilter fileFilter;
        if (!RemoteLauncher.parseCmdLineArgs(args)) {
            throw new IllegalArgumentException("Passed arguments are invalid!");
        }
        if (outputFolder != null && outputFolderClear) {
            File[] filesToDelete;
            for (File file : filesToDelete = outputFolder.listFiles()) {
                RemoteLauncher.deleteFile(file);
            }
        }
        XMLInputSource in = new XMLInputSource(descriptor);
        ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
        AnalysisEngine ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier);
        CAS cas = ae.newCAS();
        if (LauncherConstants.InputFormat.CAS.equals((Object)inputFormat)) {
            fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().endsWith(".xmi") || file.getName().endsWith(".xcas") || inputRecursive && file.isDirectory();
                }
            };
        } else if (LauncherConstants.InputFormat.PLAIN_TEXT.equals((Object)inputFormat)) {
            fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().endsWith(".txt") || inputRecursive && file.isDirectory();
                }
            };
        } else {
            throw new IllegalStateException("Unexpected input format!");
        }
        RemoteLauncher.findAndProcessFiles(inputResource, fileFilter, ae, cas);
        ae.collectionProcessComplete((ProcessTrace)new ProcessTrace_impl());
        ae.destroy();
    }

    static {
        inputFormat = LauncherConstants.InputFormat.CAS;
        inputEncoding = Charset.defaultCharset().name();
    }
}

