/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.resource.metadata.Capability;

public class AnnotationFeaturesViewer
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -8028169177689821008L;
    public static final String ROOT = "Root";
    private JScrollPane scrollPane;
    private JTree tree;
    private JButton expandAllButton;
    private JButton collapseAllButton;

    public AnnotationFeaturesViewer() {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.add((Component)this.scrollPane, "Center");
        JPanel buttonsPanel = new JPanel();
        this.expandAllButton = new JButton("Expand All");
        this.expandAllButton.setToolTipText("Expand all tree nodes");
        this.expandAllButton.addActionListener(this);
        buttonsPanel.add(this.expandAllButton);
        this.collapseAllButton = new JButton("Collapse All");
        this.collapseAllButton.setToolTipText("Collapse all tree nodes");
        this.collapseAllButton.addActionListener(this);
        buttonsPanel.add(this.collapseAllButton);
        this.add((Component)buttonsPanel, "North");
    }

    public void populate(AnalysisEngine analysisEngine, AnalysisEngineMetaData aeMetaData) {
        this.tree = this.generateTreeView(analysisEngine, aeMetaData);
        this.tree.setDragEnabled(true);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        TreeSelectionModel selectionModel = this.tree.getSelectionModel();
        selectionModel.setSelectionMode(1);
        DefaultTreeCellRenderer cellRenderer = new DefaultTreeCellRenderer();
        cellRenderer.setLeafIcon(null);
        cellRenderer.setClosedIcon(null);
        cellRenderer.setOpenIcon(null);
        this.tree.setCellRenderer(cellRenderer);
        this.scrollPane.getViewport().add((Component)this.tree, null);
    }

    private JTree generateTreeView(AnalysisEngine analysisEngine, AnalysisEngineMetaData aeMetaData) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(ROOT);
        ArrayList<String> annotationTypes = new ArrayList<String>();
        Capability[] capabilities = aeMetaData.getCapabilities();
        for (int i = 0; i < capabilities.length; ++i) {
            TypeOrFeature[] outputs = capabilities[i].getOutputs();
            for (int j = 0; j < outputs.length; ++j) {
                if (!outputs[j].isType() || annotationTypes.contains(outputs[j].getName())) continue;
                annotationTypes.add(outputs[j].getName());
            }
        }
        for (String annotationTypeName : annotationTypes) {
            DefaultMutableTreeNode annotationTreeNode = new DefaultMutableTreeNode(annotationTypeName);
            String[] featureNames = analysisEngine.getFeatureNamesForType(annotationTypeName);
            for (int i = 0; i < featureNames.length; ++i) {
                DefaultMutableTreeNode featureTreeNode = new DefaultMutableTreeNode(featureNames[i]);
                annotationTreeNode.add(featureTreeNode);
            }
            root.add(annotationTreeNode);
        }
        return new JTree(root);
    }

    public String getSelection() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            String parentPath = treePath.getParentPath().getLastPathComponent().toString();
            String lastPath = treePath.getLastPathComponent().toString();
            if (parentPath.equals(ROOT)) {
                return lastPath;
            }
            return parentPath + ":" + lastPath;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block3: {
            Object source;
            block2: {
                source = e.getSource();
                if (source != this.expandAllButton) break block2;
                for (int i = 0; i < this.tree.getRowCount(); ++i) {
                    this.tree.expandRow(i);
                }
                break block3;
            }
            if (source != this.collapseAllButton) break block3;
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                this.tree.collapseRow(i);
            }
        }
    }
}

