/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.engine;

import java.lang.invoke.MethodHandles;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.impl.cpm.engine.CPMEngine;
import org.apache.uima.collection.impl.cpm.engine.EOFToken;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class BoundedWorkQueue {
    private static final Logger LOG = UIMAFramework.getLogger(MethodHandles.lookup().lookupClass());
    protected final int queueMaxSize;
    protected List<Object> queue = new LinkedList<Object>();
    protected int numberElementsInQueue = 0;
    protected String queueName = "";
    protected CPMEngine cpm;
    protected static final int WAIT_TIMEOUT = 50;

    public BoundedWorkQueue(int aQueueSize, String aQueueName, CPMEngine aCpmEngine) {
        this.queueMaxSize = aQueueSize;
        this.queueName = aQueueName;
        this.cpm = aCpmEngine;
    }

    public String getName() {
        return this.queueName;
    }

    public synchronized int getCurrentSize() {
        Object[] list;
        Object olist;
        if (this.numberElementsInQueue > 0 && (olist = this.queue.get(0)) != null && olist instanceof Object[] && (list = (Object[])olist)[0] instanceof EOFToken) {
            return 0;
        }
        return this.numberElementsInQueue;
    }

    public int getCapacity() {
        return this.queueMaxSize;
    }

    public synchronized void enqueue(Object anObject) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            LOG.logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_entering_queue__FINEST", new Object[]{Thread.currentThread().getName(), this.queueName, String.valueOf(this.numberElementsInQueue)});
        }
        try {
            if (!(anObject instanceof Object[]) || !(((Object[])anObject)[0] instanceof EOFToken)) {
                while (this.numberElementsInQueue == this.queueMaxSize && (this.cpm == null || this.cpm.isRunning())) {
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        LOG.logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_queue_full__FINEST", new Object[]{Thread.currentThread().getName(), this.queueName, String.valueOf(this.numberElementsInQueue)});
                    }
                    this.wait(50L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            LOG.logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_adding_cas_to_queue__FINEST", new Object[]{Thread.currentThread().getName(), this.queueName, String.valueOf(this.numberElementsInQueue)});
        }
        this.queue.add(anObject);
        ++this.numberElementsInQueue;
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            LOG.logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cas_in_queue__FINEST", new Object[]{Thread.currentThread().getName(), this.queueName, String.valueOf(this.numberElementsInQueue)});
        }
        this.notifyAll();
    }

    public synchronized Object dequeue() {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            LOG.logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_enter_dequeue__FINEST", new Object[]{Thread.currentThread().getName(), this.queueName, String.valueOf(this.numberElementsInQueue)});
        }
        if (this.numberElementsInQueue == 0) {
            return null;
        }
        Object returnedObject = this.queue.remove(0);
        --this.numberElementsInQueue;
        if (returnedObject instanceof Object[]) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                LOG.logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cas_dequeued__FINEST", new Object[]{Thread.currentThread().getName(), this.queueName, String.valueOf(((Object[])returnedObject).length)});
            }
        } else if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            LOG.logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_no_cas_dequeued__FINEST", new Object[]{Thread.currentThread().getName(), this.queueName});
        }
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            LOG.logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_return_from_dequeue__FINEST", new Object[]{Thread.currentThread().getName(), this.queueName, String.valueOf(this.numberElementsInQueue)});
        }
        return returnedObject;
    }

    public synchronized Object dequeue(long aTimeout) {
        Object resource = this.dequeue();
        if (resource != null) {
            return resource;
        }
        try {
            long timeNow = System.currentTimeMillis();
            long timeExpire = !this.cpm.isRunning() ? timeNow + 50L : (0L == aTimeout ? Long.MAX_VALUE : timeNow + aTimeout + 1L);
            long timeLeft = timeExpire - timeNow;
            while (timeLeft > 0L) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    LOG.logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_queue_empty__FINEST", new Object[]{Thread.currentThread().getName(), this.queueName});
                }
                this.wait(timeLeft);
                resource = this.dequeue();
                if (null != resource) {
                    LOG.trace("[{}] Waited for {}ms", (Object)this.queueName, (Object)(timeNow - System.currentTimeMillis()));
                    return resource;
                }
                timeLeft = timeExpire - System.currentTimeMillis();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            LOG.logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_queue_notified__FINEST", new Object[]{Thread.currentThread().getName(), this.queueName, String.valueOf(this.numberElementsInQueue)});
        }
        resource = this.dequeue();
        return resource;
    }

    public void invalidate(CAS[] aCasObjectList) {
    }
}

