/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.engine;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.base_cpm.BaseStatusCallbackListener;
import org.apache.uima.collection.impl.EntityProcessStatusImpl;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;

public class CPMExecutorService
extends ThreadPoolExecutor {
    private List<BaseStatusCallbackListener> callbackListeners = null;
    private ProcessTrace procTr = null;

    public CPMExecutorService() {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public void setListeners(List<BaseStatusCallbackListener> aListenerList) {
        this.callbackListeners = aListenerList;
    }

    public void setProcessTrace(ProcessTrace aProcessTrace) {
        this.procTr = aProcessTrace;
    }

    @Override
    protected void afterExecute(Runnable aThread, Throwable aThrowable) {
        block9: {
            Throwable throwable = aThrowable;
            if (throwable == null && aThread instanceof FutureTask) {
                try {
                    ((FutureTask)aThread).get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    throwable = e.getCause();
                }
            }
            if (throwable == null) {
                return;
            }
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_unhandled_error__SEVERE", new Object[]{Thread.currentThread().getName(), throwable.getClass().getName()});
            }
            try {
                for (BaseStatusCallbackListener cbl : this.callbackListeners) {
                    this.notifyListener(cbl, throwable);
                }
            }
            catch (Throwable tr) {
                if (!UIMAFramework.getLogger().isLoggable(Level.FINER)) break block9;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINER, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception__FINER", new Object[]{Thread.currentThread().getName(), tr.getClass().getName()});
                tr.printStackTrace();
            }
        }
    }

    private void notifyListener(BaseStatusCallbackListener aStatCL, Throwable e) {
        EntityProcessStatusImpl enProcSt = new EntityProcessStatusImpl(this.procTr);
        enProcSt.addEventStatus("Process", "Failed", e);
        ((StatusCallbackListener)aStatCL).entityProcessComplete(null, (EntityProcessStatus)enProcSt);
    }

    public void cleanup() {
        this.callbackListeners = null;
        this.procTr = null;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> aCallable) {
        return new CpmFutureTask<T>(aCallable);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable aRunnable, T aValue) {
        return new CpmFutureTask<T>(aRunnable, aValue);
    }

    private class CpmFutureTask<T>
    extends FutureTask<T> {
        public CpmFutureTask(Callable<T> aCallable) {
            super(aCallable);
        }

        public CpmFutureTask(Runnable aRunnable, T aResult) {
            super(aRunnable, aResult);
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                return (T)super.get();
            }
            catch (ExecutionException e) {
                CPMExecutorService.this.afterExecute(null, e.getCause());
                return null;
            }
        }

        @Override
        public T get(long aTimeout, TimeUnit aUnit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return (T)super.get(aTimeout, aUnit);
            }
            catch (ExecutionException e) {
                CPMExecutorService.this.afterExecute(null, e.getCause());
                return null;
            }
        }
    }
}

